<?php
	include('../_global.php');
	$notes = "";
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

	<title><?php echo $configs->page_title;?></title>
	<meta content="" name="description">
	<meta content="width=device-width, initial-scale=1" name="viewport">
	<meta content="NOINDEX, NOFOLLOW" name="ROBOTS">
	<link href="<?php echo $configs->mobile_path . "assets/css/style-m.css"; ?>" rel="stylesheet">
	<link href="<?php echo $configs->mobile_path . "assets/css/custom.css"; ?>" rel="stylesheet">
	<link href="<?php echo $configs->mobile_path . "assets/css/loading.css"; ?>" rel="stylesheet">
	<link href="<?php echo $configs->mobile_path . "assets/css/common.css"; ?>" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&amp;display=swap" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.gstatic.com/">
	<link rel="shortcut icon" type="./assets/image/x-icon" href="<?php echo $configs->mobile_path . "assets/brand/favicon.png"; ?>">
	<?php include_once('../sentry.php'); ?>

	<!-- CLARITY -->
  	<script type="text/javascript">
		(function(c,l,a,r,i,t,y){
			c[a]=c[a]function(){(c[a].q=c[a].q[]).push(arguments)};
			t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
			y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
		})(window, document, "clarity", "script", "sz0rsj80xf");
	</script>
</head>
<body data-assets-id="5984" style="max-width: 600px;">
	<div id="app">
		<div id="pagecontainer">
			<div id="top-1">
				<center class="header-in">
					<img src="<?php echo $configs->mobile_path . "assets/brand/logo.png"; ?>" alt="" class="logo">
				</center>
				<div class="delivery-b">
					<span><b>Fast, Free Shipping</b> For A Limited Time</span>
				</div>
				<div class="breadcrumbs">
					<ul class="breadcrumbs__list">
						<li class="breadcrumbs__item breadcrumbs__item_active">
							<span>Qualify Now</span>
						</li>
						<li class="breadcrumbs__item breadcrumbs__item_2">
							<span>Select Package</span>
						</li>
						<li class="breadcrumbs__item breadcrumbs__item_3">
							<span>Confirm Order</span>
						</li>
					</ul>
				</div>
				<p style="text-align: center;">
					<br>
					<b style="color: #f18704; font-size: 19px;">Qualify For Your Order Today!</b>
					<br>
					<br>
				</p>
				<div id="form-error-msg"></div>
				<div class="form-partial" id="partialcontainer" style="max-width: 95%; margin: 0 auto;">
					<form name="qualify_form1" class="kform form123" id="theForm" action="../app/src/mobile_qualify.php" method="post" onsubmit="return validate_optin_form()" accept-charset="utf-8" enctype="application/x-www-form-urlencoded;charset=utf-8" _lpchecked="1">
						<input type="hidden" name="notes" value="<?php echo $notes;?>" class="has-error">
						<input type="hidden" name="country" id="country" value="US" class="no-error">    
						<?php
							foreach($_GET as $key => $value) {
								echo "<input type='hidden' name='".safeRequest($key)."' value='".safeRequest($_GET[$key])."'>";
							}
						?>
						<div class="lead-form-wrapper">
							<div class="promo-field">
								<label for="promo">Your discount code <span>activated</span></label>
								<input class="form-control" id="promo" placeholder="Promo code" disabled="" title="Promo code" type="text" value="WB78342775">
							</div>
							<div class="columns form-holder">
								<label>First Name:</label>
								<input class="form-control required" data-placement="auto left" name="shipFirstName" id='fields_fname' placeholder="First Name*" title="First Name*" type="text" value="">
							</div>
							<div class="columns form-holder">
								<label>Last Name:</label>
								<input class="form-control required" data-placement="auto left" name="shipLastName" id='fields_lname' placeholder="Last Name*" title="Last Name*" type="text" value="">
							</div>
							<div class="columns">
								<label>Email:</label>
								<input class="form-control required" data-placement="auto left" name="fields_email" id='fields_email' placeholder="Email*" title="Email" type="email" value="">
							</div>
							<div class="columns">
								<label>Phone:</label>
								<input class="form-control required" data-placement="auto left" name="fields_phone" id="fields_phone" placeholder="Phone Number*" title="Phone Number" type="tel" value="">
							</div>
							<br>
							<input id="partialSubmit" alt="Submit" class="pulsebutton btn_pulse button-form" name="partialsubmitbutton" type="submit" value="Qualify For My Order &gt;&gt;">
						</div>
					</form>
				</div>
			</div>
		</div>
		<div class="bottom-icons">
			<div class="delivery-b">
				<span><b>Fast, Free Shipping</b> For A Limited Time</span>
			</div>
		</div>
		<div class="footer-in">
			<ul>
				<li>
					<img src="<?php echo $configs->mobile_path . "assets/images/gd1.svg"; ?>" alt="">
				</li>
				<li>
					<img src="<?php echo $configs->mobile_path . "assets/images/gd2.svg"; ?>" alt="">
				</li>
				<li>
					<img src="<?php echo $configs->mobile_path . "assets/images/gd3.svg"; ?>" alt="">
				</li>
			</ul>
		</div>
		<div class="secure-in">
			<span>
				Secure Server <br>
				<span class="secure-in__text">Protected by</span> <br>
				<span class="secure-in__text2">SSL</span>
			</span>
		</div>
		<div id="footer">
			<br>
			<center>
				<p>
					<a href="javascript:void(0);" onclick="openNewWindow('../disclosures/terms.php','modal');">Terms and Conditions |</a>
					<a href="javascript:void(0);" onclick="openNewWindow('../disclosures/privacy.php','modal');">Privacy Policy |</a>
					<a href="javascript:void(0);" onclick="openNewWindow('../disclosures/contact.php','modal');">Contact us</a>
				</p>
				<br>
				<div class="text-center">
					<p>
						*The statements made on our websites have not been evaluated by
						the FDA (U.S. Food &amp; Drug Administration). Our products are
						not intended to diagnose, cure or prevent any disease. The
						information provided by this website or this company is not a
						substitute for a face-to-face consultation with your physician,
						and should not be construed as individual medical advice. The
						testimonials on this website are individual cases and do not
						guarantee that you will get the same results. Due to the nature of
						this product and to protect the disclosures/privacy.php of the individuals, actual
						names and photographs of the individuals depicted in the
						testimonials have been changed. Individuals are remunerated.
					</p>
				</div>
			</center>
			<p></p>
			<p></p>
			<p>
				<br>
			</p>
			<center>
				<br>
				<div class="text-center">
					<p class="cop-text">
						©
						<script>
							const date = new Date();
							document.write(date.getFullYear());
						</script>
						<span class="product-name"><?php echo $configs->corporate_name;?></span>. All Rights Reserved.
					</p>
				</div>
			</center>
			<p></p>
		</div>

		<!--popup processing wrapper-->
		<section id="loading-indicator" class="popup-loading-wrapper" style="display: none">
			<div class="popup">
				<img src="<?php echo $configs->mobile_path . "assets/images/icon-lock.png"; ?>" alt="" class="lock-image" />
				<p>Please wait a moment</p>
				<h3>Your Product Is Being Reserved</h3>
				<img src="<?php echo $configs->mobile_path . "assets/images/icon-loading.png"; ?>" alt="" class="loading-image" />
			</div>
		</section>
		<!--end popup processing wrapper-->
	</div>

	<script src="<?php echo $configs->mobile_path . "assets/js/jquery.min.js"; ?>"></script>
	<script src="<?php echo $configs->mobile_path . "assets/js/jquery.mask.min.js"; ?>"></script>
	<script type="text/javascript">
		$('form.form123').find('#fields_email').on('change keyup', function() {
			var emailReg2 = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
			if ( !emailReg2.test($('#fields_email').val()) ) {
				$(this).addClass('has-error');
				$(this).removeClass('no-error');
			}
		});

		$('form.form123').find('#fields_zip').on('change keyup', function() {
			var zip = $('#fields_zip').val();
			if ((zip.length)< 5 ){
				$(this).addClass('has-error');
				$(this).removeClass('no-error');
			}
		});

		$('form#theForm').find('input, select, textarea').on('change keyup', function() {
			$('form#theForm').find('input, select').not('#partialSubmit').each(function() {
				if($(this).val()==''){
					$(this).addClass('has-error');
					$(this).removeClass('no-error');
				}else{
					$(this).removeClass('has-error');
					$(this).addClass('no-error');	
				}
			});
		});

		function validate_optin_form(){
			ShowExitPopup = false;
			internal = 1;
			isExit=false;

			var errors = new Array();
			var phonefilter = /^([0-9\-\+\(\)]{8,22})+$/ ;
			var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;

			$("input").removeClass("has-error");
			
			if ($('#fields_fname').val().replace(/^\s+|\s+$/g,"")=='') {
				errors.push('Please enter your first name');
				$('#fields_fname').addClass("has-error");
			}
			if ($('#fields_lname').val().replace(/^\s+|\s+$/g,"")=='') {
				errors.push('Please enter your last name');
				$('#fields_lname').addClass("has-error");
			}
			if ($('#fields_email').val().replace(/^\s+|\s+$/g,"")=='') {
				errors.push('Please enter your email address');
				$('#fields_email').addClass("has-error");
			} else if ( !emailReg.test($('#fields_email').val()) ) {
				errors.push('Please enter valid email address');
				$('#fields_email').addClass("has-error");
			}
			if ($('#fields_phone').val().replace(/^\s+|\s+$/g,"")=='') {
				errors.push('Please enter your phone number');
				$('#fields_phone').addClass("has-error");
			} else if ($('#fields_phone').val().replace(/^\s+|\s+$/g,"").length < 12) {
				errors.push('Phone number must be at least 10 digits');
				$('#fields_phone').addClass("has-error");
			}
			
			if (errors.length == 0 ) {
				$('#loading-indicator').fadeIn(500, function(){
					$('#fields_phone').unmask();
					document.getElementById('theForm').submit();
				});
				return false;
			} else {
				var li = '';
				$.each(errors, function(key, value) {
					li += '<li>' + value + '</li>';
				});
			
				var html = '';
				html += '<div id="error_handler_overlay">';
				html += '<div class="error_handler_body"><a href="javascript:void(0);" id="error_handler_overlay_close">X</a><ul>' + li + '</ul></div>';
				html += '</div>';
			
				$('body').append(html);
			
				$('#error_handler_overlay').fadeIn(500);
				return false;
			}
		}

		$(function() {
			$('#fields_phone').mask('000-000-0000');
			
			$(window).keydown(function(e) {
				if (e.which === 27 && $('#error_handler_overlay').length) {
					$('#error_handler_overlay').remove();
				}
			});
			
			$(document).off('click', '#error_handler_overlay');
			$(document).on('click', '#error_handler_overlay', function() {
				$(this).remove();
			});

			$(document).off('click', '#error_handler_overlay_close');
			$(document).on('click', '#error_handler_overlay_close', function() {
				$('#error_handler_overlay').remove();
			});

			$(document).on('click', '#app_common_modal_close', function() {
				$('#app_common_modal').remove();
			});	
		});

		function openNewWindow(page_url, type, window_name, width, height, top, left, features) {
			if (!type) {
				type = 'popup';
			}
			if (!width) {
				width = 480;
			}
			if (!height) {
				height = 480;
			}
			if (!top) {
				top = 50;
			}
			if (!left) {
				left = 50;
			}
			if (!features) {
				features = 'resizable,scrollbars';
			}

			if (type == 'popup') {
				var settings = 'height=' + height + ',';
				settings += 'width=' + width + ',';
				settings += 'top=' + top + ',';
				settings += 'left=' + left + ',';
				settings += features;

				win = window.open(page_url, window_name, settings);
				win.window.focus();
			} else if (type == 'modal') {
				var html = '';
				html += '<div id="app_common_modal">';
				html += '<div class="app_modal_body"><a href="javascript:void(0);" id="app_common_modal_close">X</a><iframe src="' + page_url + '" frameborder="0"></iframe></div>';
				html += '</div>';

				if (!$('#app_common_modal').length) {

					$('body').append(html);
				}
				$('#app_common_modal').fadeIn();
			}
		}
	</script>
</body>
</html>