(function(exports) { 
    function ThreeDS(formId,apiKey,token,options){this.version="2.1.0.20210929";this.timeoutID=null;this.apiKey=apiKey;this.formId=formId;this.isRebill=false;this.delayedRebill=false;this.defaults={verbose:false,endpoint:"https://api.3dsintegrator.com/v2",autoSubmit:true,addResultToForm:true,iframeId:"__threeds"+(Math.random()*5E3<<0),eciInputId:"eci",cavvInputId:"cavv",xidInputId:"xid",protocolVersionInputId:"protocolVersion",statusInputId:"status",authenticationValueInput:"authenticationValue",dsTransactionIdInput:"dsTransactionId",
    amexDSTransactionIdInput:"amexDsTransId",rebill:0,resolve:null,reject:null,showIframe:false,allowRetry:false,popup:false,prompt:null,start:null,authorizationComplete:null,protocolVersion:null,challengeWindowSize:"01",messageCategory:"01",currency:null,currencyExponent:null,challengeIndicator:"01",showChallenge:false,timeout:8E3,popupFail:null,clientTransactionId:null,domain:null,rebillSubmitDelay:null,forcedTimeout:null};this.options=Object.assign(this.defaults,options);this.token=token;this.errors=
    [];this.verifyListener=this.verify.bind(this,this.options.resolve,this.options.reject);this.formFields=null;this.threeDsTransactionId=null;this.transactionLastUpdatedTime=null;this.pollingResponse=null;this.isChallengeVisable=false;this.rebillForcedTimeout=null;this.initialForcedTimeout=null;this.timeTakenForInitial=null;this.init()}
    ThreeDS.prototype={init:function(){var threedsGlobal=this;if(this.options.verbose)console.log(this.version);if(!this.validateConfigs()){if(this.options.verbose)console.log(this.errors);return}if(!this.token)this.getToken(function(response){if(threedsGlobal.options.authorizationComplete instanceof Function)threedsGlobal.options.authorizationComplete(response)});threedsGlobal.formFields=this.getTransactionFields();if(this.options.autoSubmit)this.attachEventToField("blur",[threedsGlobal.formFields.panInput,
    threedsGlobal.formFields.monthInput,threedsGlobal.formFields.yearInput]);Object.defineProperty(threedsGlobal,"challengeStatus",{set:function(value){if(value==="C"){if(!threedsGlobal.isChallengeVisable)threedsGlobal.doChallenge();threedsGlobal.getTransactionUpdates(threedsGlobal.threeDsTransactionId,threedsGlobal.transactionLastUpdatedTime)}else{var iframe=document.getElementById(threedsGlobal.options.iframeId);if(iframe&&iframe.parentNode)iframe.parentNode.removeChild(iframe);if(threedsGlobal.popupWindow)threedsGlobal.popupWindow.close();
    threedsGlobal.isChallengeVisable=false}}})},getToken:function(onAuthorize){var threedsGlobal=this;this.request("POST",this.options.endpoint+"/authorize",null,null,function(responseData){var authorizationHeader=responseData.getResponseHeader("Authorization");var response=JSON.parse(responseData.response);if(authorizationHeader){threedsGlobal.token=authorizationHeader.replace("Bearer ","");if(threedsGlobal.options.verbose){console.log("DEBUG","Token Received");console.log("Authorization ",authorizationHeader)}}onAuthorize(response)},
    function(error){if(threedsGlobal.options.verbose)console.log(error.response)})},request:function(requestMethod,endpoint,data,headers,successCallback,failureCallback){var httpRequest=new XMLHttpRequest;httpRequest.addEventListener("load",function(){if(httpRequest.status>=400)failureCallback(httpRequest);else successCallback(httpRequest)});httpRequest.addEventListener("error",function(){failureCallback(httpRequest)});httpRequest.open(requestMethod,endpoint);httpRequest.setRequestHeader("Content-Type",
    "application/json");httpRequest.setRequestHeader("X-3DS-API-KEY",this.apiKey);httpRequest.setRequestHeader("X-3DS-SDK-VERSION",this.version);if(headers)for(var header in headers)httpRequest.setRequestHeader(header,headers[header]);if(this.token)httpRequest.setRequestHeader("Authorization","Bearer "+this.token);httpRequest.send(data!=null?JSON.stringify(data):data)},validateTransactionDetails:function(){this.errors.length=0;if(!this.formFields.cctokenInput&&!this.formFields.panInput)this.errors.push("1 element MUST be tagged with the attribute 'data-threeds\x3d\"pan\"' OR 'data-threeds\x3d\"cctoken\"'");
    this.formFields.panInput&&this.validateCreditCard(this.formFields.panInput.value);if(this.formFields.cctokenInput&&!this.formFields.cctokenInput.value)this.errors.push("Card Token Missing");if(this.formFields.amountInput&&!Number(this.formFields.amountInput.value))this.errors.push("Invalid Amount");if(!this.formFields.monthInput)this.errors.push("1 element MUST be tagged with the attribute 'data-threeds\x3d\"month\"'");if(this.formFields.monthInput&&!Number(this.formFields.monthInput.value))this.errors.push("Invalid Month");
    if(!this.formFields.yearInput)this.errors.push("1 element MUST be tagged with the attribute 'data-threeds\x3d\"year\"'");if(this.formFields.yearInput&&!Number(this.formFields.yearInput.value))this.errors.push("Invalid Year");if(this.formFields.currencyInput&&!Number(this.formFields.currencyInput.value))this.errors.push("Invalid Currency Provided");return this.errors.length?false:true},getTransactionFields:function(){var form=document.getElementById(this.formId);return{cctokenInput:form.querySelector("[data-threeds\x3dcctoken]"),
    panInput:form.querySelector("[data-threeds\x3dpan]"),amountInput:form.querySelector("[data-threeds\x3damount]"),monthInput:form.querySelector("[data-threeds\x3dmonth]"),yearInput:form.querySelector("[data-threeds\x3dyear]"),emailInput:form.querySelector("[data-threeds\x3demail]"),currencyInput:form.querySelector("[data-threeds\x3dcurrency]"),shipping:{line1Input:form.querySelector("[data-threeds\x3dshippingLine1]"),line2Input:form.querySelector("[data-threeds\x3dshippingLine2]"),line3Input:form.querySelector("[data-threeds\x3dshippingLine3]"),
    postCodeInput:form.querySelector("[data-threeds\x3dshippingPostCode]"),cityInput:form.querySelector("[data-threeds\x3dshippingCity]"),stateInput:form.querySelector("[data-threeds\x3dshippingState]"),countryInput:form.querySelector("[data-threeds\x3dshippingCountry]")},billing:{line1Input:form.querySelector("[data-threeds\x3dbillingLine1]"),line2Input:form.querySelector("[data-threeds\x3dbillingLine2]"),line3Input:form.querySelector("[data-threeds\x3dbillingLine3]"),postCodeInput:form.querySelector("[data-threeds\x3dbillingPostCode]"),
    cityInput:form.querySelector("[data-threeds\x3dbillingCity]"),stateInput:form.querySelector("[data-threeds\x3dbillingState]"),countryInput:form.querySelector("[data-threeds\x3dbillingCountry]")},cardHolderNameInput:form.querySelector("[data-threeds\x3dcardHolderName]"),threeRIIndicatorInput:form.querySelector("[data-threeds\x3dthreeRIIndicator]"),transTypeInput:form.querySelector("[data-threeds\x3dtransType]"),merchantRiskIndicator:{shipIndicatorInput:form.querySelector("[data-threeds\x3dshipIndicator]"),
    deliveryTimeFrameInput:form.querySelector("[data-threeds\x3ddeliveryTimeFrame]"),reorderItemsIndInput:form.querySelector("[data-threeds\x3dreorderItemsInd]")}}},getAuthData:function(data){var transactionData={cardToken:this.formFields.cctokenInput?this.formFields.cctokenInput.value.trim():null,pan:this.formFields.panInput?this.formFields.panInput.value.trim():null,amount:this.isRebill?Number(this.options.rebill):data!==undefined&&data!==null&&data.amount!==undefined?data.amount:Number(this.formFields.amountInput.value),
    month:this.formFields.monthInput.value.slice(0,2),year:this.formFields.yearInput.value.slice(-2),clientTransactionId:this.options.clientTransactionId,protocolVersion:this.options.protocolVersion,currency:this.formFields.currencyInput?this.formFields.currencyInput.value:this.options.currency,currencyExponent:this.options.currencyExponent,email:this.formFields.emailInput?this.formFields.emailInput.value:null,shipping:{line1:this.formFields.shipping.line1Input?this.formFields.shipping.line1Input.value:
    null,line2:this.formFields.shipping.line2Input?this.formFields.shipping.line2Input.value:null,line3:this.formFields.shipping.line3Input?this.formFields.shipping.line3Input.value:null,postCode:this.formFields.shipping.postCodeInput?this.formFields.shipping.postCodeInput.value:null,city:this.formFields.shipping.cityInput?this.formFields.shipping.cityInput.value:null,state:this.formFields.shipping.stateInput?this.formFields.shipping.stateInput.value:null,country:this.formFields.shipping.countryInput?
    this.formFields.shipping.countryInput.value:null},billing:{line1:this.formFields.billing.line1Input?this.formFields.billing.line1Input.value:null,line2:this.formFields.billing.line2Input?this.formFields.billing.line2Input.value:null,line3:this.formFields.billing.line3Input?this.formFields.billing.line3Input.value:null,postCode:this.formFields.billing.postCodeInput?this.formFields.billing.postCodeInput.value:null,city:this.formFields.billing.cityInput?this.formFields.billing.cityInput.value:null,state:this.formFields.billing.stateInput?
    this.formFields.billing.stateInput.value:null,country:this.formFields.billing.countryInput?this.formFields.billing.countryInput.value:null},cardHolderName:this.formFields.cardHolderNameInput?this.formFields.cardHolderNameInput.value:null,threeRIIndicator:this.formFields.threeRIIndicatorInput?this.formFields.threeRIIndicatorInput.value:null,transType:this.formFields.transTypeInput?this.formFields.transTypeInput.value:null,messageCategory:this.options.messageCategory,browser:{browserIP:null,browserAcceptHeader:"application/json",
    browserJavaEnabled:window.navigator.javaEnabled(),browserJavascriptEnabled:true,browserLanguage:window.navigator.language,browserColorDepth:window.screen.colorDepth.toString(),browserScreenWidth:window.screen.width.toString(),browserScreenHeight:window.screen.height.toString(),browserTZ:(new Date).getTimezoneOffset().toString(),browserUserAgent:window.navigator.userAgent},challengeIndicator:!this.options.showChallenge&&!this.options.showIframe?"02":this.options.challengeIndicator,challengeWindowSize:this.options.challengeWindowSize,
    merchantRiskIndicator:{shipIndicator:this.formFields.merchantRiskIndicator.shipIndicatorInput?this.formFields.merchantRiskIndicator.shipIndicatorInput.value:null,deliveryTimeFrame:this.formFields.merchantRiskIndicator.deliveryTimeFrameInput?this.formFields.merchantRiskIndicator.deliveryTimeFrameInput.value:null,reorderItemsInd:this.formFields.merchantRiskIndicator.reorderItemsIndInput?this.formFields.merchantRiskIndicator.reorderItemsIndInput.value:null}};if(this.options.domain!==null)transactionData.threeDSRequestorURL=
    this.options.domain;if(this.isRebill){if(this.rebillForcedTimeout)transactionData.transactionForcedTimeout=this.rebillForcedTimeout.toString()}else if(this.initialForcedTimeout)transactionData.transactionForcedTimeout=this.initialForcedTimeout.toString();Object.assign(transactionData,data);if(this.options.verbose){console.log("amount",transactionData.amount);console.log("pan",transactionData.pan);console.log("month",transactionData.month);console.log("year",transactionData.year);console.log("clientTransactionId",
    transactionData.clientTransactionId);console.log("cctoken",transactionData.cctoken);console.log("domain",transactionData.threeDSRequestorURL)}return this.stripNullProps(transactionData)},verify:function(resolve,reject,data,getmessageExtension,getAccountInfo){var threedsGlobal=this;this.verifyResolve=resolve||this.options.resolve||this.defaultResolveHandler.bind(this);this.verifyReject=reject||this.options.reject||this.defaultRejectHandler.bind(this);if(!threedsGlobal.setInternalForcedTimeouts()){if(this.options.verbose)console.log(this.errors);
    reject(this.errors);return}if(!this.token){this.getToken(function(response){if(threedsGlobal.options.authorizationComplete instanceof Function)threedsGlobal.options.authorizationComplete(response);threedsGlobal.verify(threedsGlobal.verifyResolve,threedsGlobal.verifyReject,data,getmessageExtension,getAccountInfo)});return}if(!this.validateTransactionDetails()){if(this.options.verbose)console.log(this.errors);return}if(threedsGlobal.options.rebill&&threedsGlobal.options.rebillSubmitDelay!==null&&!threedsGlobal.isRebill)threedsGlobal.rebillAfterDelay(resolve,
    reject);var data=this.getAuthData(data);var startDate=new Date;if(getmessageExtension instanceof Function)Object.assign(data,{messageExtension:getmessageExtension()});if(getAccountInfo instanceof Function)Object.assign(data,{accInfo:getAccountInfo()});if(this.options.start instanceof Function)this.options.start({amount:data.amount,transactionId:data.clientTransactionId});if(!this.options.allowRetry&&this.options.autoSubmit)this.detachEventFromField("blur",[this.formFields.panInput,this.formFields.monthInput,
    this.formFields.yearInput]);this.request("POST",this.options.endpoint+"/authenticate/browser",data,null,function(responseData){var response=JSON.parse(responseData.response);var authorization=responseData.getResponseHeader("Authorization");threedsGlobal.threeDsTransactionId=responseData.getResponseHeader("x-3ds-transaction-id");if(!authorization){if(threedsGlobal.options.verbose)console.log("Missing authorization header");return}if(threedsGlobal.options.verbose)console.log("DEBUG","Authentication Info",
    response);threedsGlobal.token=authorization.replace("Bearer ","");threedsGlobal.protocolVersion=response.protocolVersion;if(parseFloat(response.protocolVersion)>=2)"methodURL"in response&&threedsGlobal.createIframe({threeDSMethodData:response.threeDSMethodData,methodURL:response.methodURL});else{"AcsURL"in response&&threedsGlobal.createIframe({AcsURL:response.AcsURL,MD:response.MD,PaReq:response.PaReq,TermUrl:response.TermUrl},threedsGlobal.options.iframeId);threedsGlobal.setUpPromptCheck(response.authenticateWindowURL)}if(!threedsGlobal.isRebill){var endDate=
    new Date;threedsGlobal.timeTakenForInitial=threedsGlobal.getTimeElapsed(startDate,endDate)}threedsGlobal.getTransactionUpdates(threedsGlobal.threeDsTransactionId,null,threedsGlobal.verifyResolve,threedsGlobal.verifyReject)},function(error){if(!threedsGlobal.isRebill){var endDate=new Date;threedsGlobal.timeTakenForInitial=threedsGlobal.getTimeElapsed(startDate,endDate)}threedsGlobal.verifyReject(error.response)})},validateConfigs:function(){this.errors.length=0;if(!this.apiKey)this.errors.push("Please provide an api key");
    if(!this.formId||!document.getElementById(this.formId))this.errors.push("Please provide a valid form ID");if(!this.options.rebill&&this.options.rebillSubmitDelay)this.errors.push("rebill delay passed, but no rebill was specified");if(this.options.rebillSubmitDelay)this.options.rebillSubmitDelay=parseInt(this.options.rebillSubmitDelay);if(this.options.forcedTimeout&&this.options.forcedTimeout<1.5)this.errors.push("the minimum time for forced timeout is 1.5s");return this.errors.length?false:true},
    attachEventToField:function(eventName,fields){fields.forEach(function(field,index,fields){if(fields[index])fields[index].addEventListener(eventName,this.verifyListener)},this)},detachEventFromField:function(eventName,fields){fields.forEach(function(field,index,fields){if(fields[index])fields[index].removeEventListener(eventName,this.verifyListener)},this)},createIframe:function(data,id){var formId=this.generateUniqueId();var actionUrl=data.methodURL||data.AcsURL;var iframeDoc='\x3cform name\x3d"form3ds" id\x3d"'+
    formId+'" action\x3d"'+actionUrl+'" method\x3d"post"\x3e';for(property in data){if(property==="methodUrl"||property==="AcsURL")continue;iframeDoc+='\x3cinput type\x3d"hidden" name\x3d"'+property+'" value\x3d"'+data[property]+'" /\x3e'}iframeDoc+="\x3c/form\x3e"+"\x3cscript\x3e"+'document.getElementById("'+formId+'").submit();'+"\x3c/script\x3e";var iframe=document.getElementById(id);var billingForm=document.getElementById(this.formId);if(!iframe){iframe=document.createElement("iframe");if(id!==undefined)iframe.setAttribute("id",
    id);iframe.setAttribute("style","display:none");billingForm.parentNode.appendChild(iframe)}iframe.contentDocument.write(iframeDoc);return iframe},generateUniqueId:function(){return"id-"+Math.random().toString(36).substr(2,16)},insertAuthenticationDetails:function(transactionID,data,resolve,reject){var fields=this.getAuthenticationFields();var div=document.createElement("div");var doc="";if(!fields.eciInput||!fields.cavvInput||!fields.xidInput)doc+='\x3cinput type\x3d"hidden" name\x3d"'+this.options.eciInputId+
    '" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"'+this.options.cavvInputId+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"'+this.options.xidInputId+'" value\x3d"" /\x3e';if(!fields.statusInput||!fields.protocolVersionInput)doc+='\x3cinput type\x3d"hidden" name\x3d"'+this.options.statusInputId+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"'+this.options.protocolVersionInputId+'" value\x3d"" /\x3e';if(parseFloat(data.protocolVersion)>=2){doc+='\x3cinput type\x3d"hidden" name\x3d"'+
    this.options.authenticationValueInput+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"'+this.options.dsTransactionIdInput+'" value\x3d"" /\x3e';if(data.amexDsTransId!==undefined)doc+='\x3cinput type\x3d"hidden" name\x3d"'+this.options.amexDSTransactionIdInput+'" value\x3d"" /\x3e'}if(this.isRebill){doc='\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.eciInputId+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.cavvInputId+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"rebill_'+
    this.options.xidInputId+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.statusInputId+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.protocolVersionInputId+'" value\x3d"" /\x3e';if(parseFloat(data.protocolVersion)>=2){doc+='\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.authenticationValueInput+'" value\x3d"" /\x3e'+'\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.dsTransactionIdInput+'" value\x3d"" /\x3e';if(data.amexDsTransId!==
    undefined)doc+='\x3cinput type\x3d"hidden" name\x3d"rebill_'+this.options.amexDSTransactionIdInput+'" value\x3d"" /\x3e'}}div.innerHTML=doc;document.getElementById(this.formId).appendChild(div);fields=this.getAuthenticationFields();fields.eciInput.value=data.eci;fields.cavvInput.value=data.cavv||data.authenticationValue||"";fields.xidInput.value=data.xid||transactionID||"";fields.statusInput.value=data.status;fields.protocolVersionInput.value=data.protocolVersion;if(parseFloat(data.protocolVersion)>=
    2){fields.authenticationValueInput.value=data.authenticationValue;fields.dsTransactionIdInput.value=data.dsTransId;if(data.amexDsTransId!==undefined)fields.amexDSTransactionIdInput.value=data.amexDsTransId}if(this.options.rebill&&!this.isRebill&&!this.delayedRebill){this.isRebill=true;this.transactionLastUpdatedTime=null;this.verify(resolve,reject)}},getAuthenticationFields:function(){var form=document.getElementById(this.formId);var fields=null;if(this.isRebill){fields={eciInput:form.querySelector("input[name\x3d'rebill_"+
    this.options.eciInputId+"']"),cavvInput:form.querySelector("input[name\x3d'rebill_"+this.options.cavvInputId+"']"),xidInput:form.querySelector("input[name\x3d'rebill_"+this.options.xidInputId+"']"),statusInput:form.querySelector("input[name\x3d'rebill_"+this.options.statusInputId+"']"),protocolVersionInput:form.querySelector("input[name\x3d'rebill_"+this.options.protocolVersionInputId+"']")};if(parseFloat(this.protocolVersion)>=2){fields.authenticationValueInput=form.querySelector("input[name\x3d'rebill_"+
    this.options.authenticationValueInput+"']");fields.dsTransactionIdInput=form.querySelector("input[name\x3d'rebill_"+this.options.dsTransactionIdInput+"']");fields.amexDSTransactionIdInput=form.querySelector("input[name\x3d'rebill_"+this.options.amexDSTransactionIdInput+"']")}}else{fields={eciInput:form.querySelector("input[name\x3d'"+this.options.eciInputId+"']"),cavvInput:form.querySelector("input[name\x3d'"+this.options.cavvInputId+"']"),xidInput:form.querySelector("input[name\x3d'"+this.options.xidInputId+
    "']"),statusInput:form.querySelector("input[name\x3d'"+this.options.statusInputId+"']"),protocolVersionInput:form.querySelector("input[name\x3d'"+this.options.protocolVersionInputId+"']")};if(parseFloat(this.protocolVersion)>=2){fields.authenticationValueInput=form.querySelector("input[name\x3d'"+this.options.authenticationValueInput+"']");fields.dsTransactionIdInput=form.querySelector("input[name\x3d'"+this.options.dsTransactionIdInput+"']");fields.amexDSTransactionIdInput=form.querySelector("input[name\x3d'"+
    this.options.amexDSTransactionIdInput+"']")}}return fields},defaultRejectHandler:function(error){if(this.options.verbose)console.log(error)},defaultResolveHandler:function(response){if(this.options.verbose)console.log(response)},validateCreditCard:function(creditCard){if(!creditCard||creditCard.toString().length<15){this.errors.push("Error, Invalid credit card information");return false}return true},getTransactionUpdates:function(transactionId,transactionLastUpdatedTime,resolve,reject){var threedsGlobal=
    this;var headers=null;resolve=resolve||this.verifyResolve||this.options.resolve||this.defaultResolveHandler.bind(this);reject=reject||this.verifyReject||this.options.resolve||this.defaultRejectHandler.bind(this);if(!transactionId){if(this.options.verbose)console.log("Please provide a 3Ds Transaction ID");return}if(transactionLastUpdatedTime)headers={"x-3ds-transaction-updated":transactionLastUpdatedTime};this.request("GET",this.options.endpoint+"/transaction/"+transactionId+"/updates",null,headers,
    function(responseData){var response=JSON.parse(responseData.response);threedsGlobal.transactionLastUpdatedTime=responseData.getResponseHeader("x-3ds-transaction-updated");if(threedsGlobal.options.verbose)if(parseFloat(response.protocolVersion)>=2){console.log("eci: ",response.eci);console.log("authenticationValue: ",response.authenticationValue);console.log("acsTransId: ",response.acsTransId);console.log("dsTransId: ",response.dsTransId);console.log("status: ",response.status);console.log("protocolVersion: ",
    response.protocolVersion);console.log("scaIndicator",response.scaIndicator);if(response.amexDsTransId!==undefined)console.log("amexDsTransId",response.amexDsTransId);if(response.transStatusReason!==undefined){console.log("transStatusReason: ",response.transStatusReason);console.log("transStatusReasonDetail: ",response.transStatusReasonDetail)}}else{console.log("eci: ",response.eci);console.log("cavv: ",response.cavv);console.log("xid: ",response.xid);console.log("status: ",response.status);console.log("protocolVersion: ",
    response.protocolVersion)}if(response.scaIndicator)threedsGlobal.options.showChallenge=true;threedsGlobal.pollingResponse=response;threedsGlobal.challengeStatus=response.status;if(response.status==="C"||responseData.status>400)return;if(threedsGlobal.promptTimeoutID)clearTimeout(threedsGlobal.promptTimeoutID);if(threedsGlobal.options.addResultToForm)threedsGlobal.insertAuthenticationDetails(transactionId,response,resolve,reject);resolve(response)},function(error){if(error.status===404)threedsGlobal.challengeStatus=
    "C";reject(error.response)})},doChallenge:function(){this.isChallengeVisable=true;if(parseFloat(this.protocolVersion)<2||!this.pollingResponse||!"acsURL"in this.pollingResponse)return;if(!this.options.popup){var iframe=this.createIframe({AcsURL:this.pollingResponse.acsURL,creq:this.pollingResponse.creq},this.options.iframeId);if(this.options.showIframe||this.options.showChallenge)iframe.setAttribute("style","display:block");else this.closeIframe()}else{var dimenisons=this.getWindowSize();var windowSpecs=
    "scrollbars\x3dyes,width\x3d"+dimenisons.width+",height\x3d"+dimenisons.height;var url=this.options.endpoint+this.pollingResponse.challengeWindowURL.href+"?jwt\x3d"+this.token;this.popupWindow=window.open(url,"Challenge Window",windowSpecs);if(this.popupWindow===null&&this.options.verbose===true)console.debug("The browser is blocking popups. To complete the authentication process the user must visit this url "+this.pollingResponse.challengeWindowURL.href+". This can be done by using the popupFail option to set a function that receives the url and shows it in an iframe, opens a tab, or shows the user the url to click");
    if(this.popupWindow===null&&this.options.popupFail!==null)this.options.popupFail(this.pollingResponse.challengeWindowURL.href)}this.options.prompt&&this.options.prompt(this.pollingResponse)},closeIframe:function(){var threedsGlobal=this;if(threedsGlobal.options.iframeId!=null)this.promptTimeoutID=setTimeout(function(){if(threedsGlobal.options.verbose===true)console.log("closing Iframe");var iframe=document.getElementById(threedsGlobal.options.iframeId);if(iframe&&iframe.parentNode)iframe.parentNode.removeChild(iframe);
    this.isChallengeVisable=false},3E3)},stripNullProps:function(data){var threedsGlobal=this;if(typeof data!=="object")return false;Object.keys(data).forEach(function(key){if(data[key]===null){delete data[key];return}if(typeof data[key]==="object")threedsGlobal.stripNullProps(data[key]);if(typeof data[key]==="object"&&Object.keys(data[key]).length<1)delete data[key]});return data},setUpPromptCheck:function(authenticateWindowURL){var threedsGlobal=this;var timeout=this.options.showChallenge?this.options.timeout:
    8E3;if(this.options.popup){var dimenisons=this.getWindowSize();var windowSpecs="scrollbars\x3dyes,width\x3d"+dimenisons.width+",height\x3d"+dimenisons.height;var url=threedsGlobal.options.endpoint+authenticateWindowURL.href+"?jwt\x3d"+threedsGlobal.token;threedsGlobal.popupWindow=window.open(url,"Challenge Window",windowSpecs);if(threedsGlobal.popupWindow===null&&this.options.verbose===true)console.debug("The browser is blocking popups. To complete the authentication process the user must visit this url "+
    url+". This can be done by using the popupFail option to set a function that receives the url and shows it in an iframe, opens a tab, or shows the user the url to click");if(threedsGlobal.popupWindow===null&&threedsGlobal.options.popupFail!==null)threedsGlobal.options.popupFail(url)}else if(this.options.showIframe||this.options.showChallenge){var g=this;this.promptTimeoutID=setTimeout(function(){var iframe=document.getElementById(threedsGlobal.options.iframeId);iframe.setAttribute("style","display:block");
    g.options.prompt&&g.options.prompt()},timeout)}},getWindowSize:function(){var dimenisons={};switch(this.options.challengeWindowSize){case "01":dimenisons.width=250;dimenisons.height=400;break;case "02":dimenisons.width=390;dimenisons.height=400;break;case "03":dimenisons.width=500;dimenisons.height=600;break;case "04":dimenisons.width=600;dimenisons.height=400;break;default:dimenisons.width=1E3;dimenisons.height=1E3}return dimenisons},rebillAfterDelay:function(resolve,reject){var threedsGlobal=this;
    this.errors.length=0;this.verifyResolve=resolve||this.options.resolve||this.defaultResolveHandler.bind(this);this.verifyReject=reject||this.options.reject||this.defaultRejectHandler.bind(this);if(threedsGlobal.options.verbose)console.log("DEBUG","waiting "+this.options.rebillSubmitDelay+"seconds before calling rebill");this.delayedRebill=true;if(this.options.rebillSubmitDelay>5){if(threedsGlobal.options.verbose)console.log("WARN","rebill submit delay "+this.options.rebillSubmitDelay+"more than allowed defaulting to 5 seconds max");
    this.options.rebillSubmitDelay=5}if(threedsGlobal.options.rebillSubmitDelay!==0)setTimeout(function(){threedsGlobal.reinstantiateRebillSDK(resolve,reject)},threedsGlobal.options.rebillSubmitDelay*1E3);else setTimeout(function(){threedsGlobal.reinstantiateRebillSDK(resolve,reject)},50)},reinstantiateRebillSDK:function(resolve,reject){var threedsGlobal=this;if(threedsGlobal.options.verbose)console.log("DEBUG","instantiating delayed rebill");tdsRebill=new ThreeDS(threedsGlobal.formId,threedsGlobal.apiKey,
    threedsGlobal.total,threedsGlobal.options);tdsRebill.isRebill=true;tdsRebill.options.autoSubmit=false;tdsRebill.options.allowRetry=false;tdsRebill.options.iframeId="__threeds"+(Math.random()*5E3<<0);tdsRebill.verify(resolve,reject)},setInternalForcedTimeouts:function(){this.errors.length=0;if(this.isRebill)if(this.options.rebillSubmitDelay!==null&&this.options.forcedTimeout){this.initialForcedTimeout=this.options.forcedTimeout;this.rebillForcedTimeout=this.options.forcedTimeout-this.options.rebillSubmitDelay;
    if(this.rebillForcedTimeout<1.5){if(this.options.verbose){console.log("the combination of the rebill, forced timeout and the rebill submit delay does not give enough time for the rebill to be done. ");console.log("the SDK will be reconfigured automatically to prioritize the initial, and the rebill won't be done. ");console.log("please reach out to support, or set a lower value for the rebill submit delay.")}this.initialForcedTimeout=this.options.forcedTimeout;this.errors.push("not enough time to do rebill, exiting.")}}else{if(this.timeTakenForInitial&&
    !this.options.rebillSubmitDelay&&this.options.forcedTimeout){this.rebillForcedTimeout=this.options.forcedTimeout-this.timeTakenForInitial;if(this.rebillForcedTimeout<1.5){if(this.options.verbose){console.log("the combination of the initial result, forced timeout does not give enough time for the rebill to be done. ");console.log("the SDK will not do the rebill")}this.errors.push("not enough time to do rebill, exiting.")}}}else this.initialForcedTimeout=this.options.forcedTimeout;return this.errors.length?
    false:true},getTimeElapsed:function(startDate,endDate){var timeDiff=endDate-startDate;timeDiff/=1E3;var seconds=Math.round(timeDiff);if(this.options.verbose)console.log("the time taken for authenticate call: "+seconds+" seconds");return seconds}};
     exports.ThreeDS = ThreeDS;})(this);