<?php
include("_global.php");
include("add-ons/Pixel.php");
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <title><?php echo $configs->page_title; ?></title>
  <meta name="description" content="<?php echo $configs->step1_name; ?>">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta http-equiv="content-language" content="en-us">
  <meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=no">
  <link rel="shortcut icon" type="/assets/image/x-icon" href="<?php echo $configs->root_path . "/assets/brand/favicon.png"; ?>">
  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/app.0decdacc.css">
  <link rel="stylesheet" href="assets/css/CcPageDesktop.bbeb7fb3.css">
  <!-- <link rel="stylesheet" href="<?php //echo $configs->root_path . "/assets/css/KonnektFooter.8c1e638e.html"; 
                                    ?>"> -->
  <link rel="stylesheet" href="<?php echo $configs->root_path . "/assets/css/loading.css"; ?>">
  <link rel="stylesheet" href="<?php echo $configs->root_path . "/assets/css/modal7b30.css?v=4"; ?>">
  <link rel="stylesheet" type="text/css" href="<?php echo $configs->root_path . "/assets/css/common.css"; ?>">

  <style>
    .package-images__item .bonus-border .bonus-free .save-block .save-price {
      font-size: 10px;
    }

    input[type=text],
    input[type=search],
    input[type=number],
    input[type=password],
    input[type=tel],
    input[type=email],
    select,
    textarea {
      height: 43px;
    }

    .terms_content_area p {
      font-size: 13px;
      margin: 10px 0 10px;
      color: #848484;
      line-height: 18px;
      text-align: center;
    }

    .terms_content_area p a {
      color: #084576;
      text-decoration: underline;
    }

    .subscribe_label [type="checkbox"] {
      display: inline-block;
      vertical-align: middle;
      width: 18px;
      height: 18px;
      background-color: #a5b1c3 !important;
      border-radius: 4px;
      margin-right: 2px;
      position: relative;
    }

    .subscribe_label label {
      display: inline-block;
      vertical-align: middle;
      color: #a5b1c3;
      font-size: 0.8rem;
      font-weight: 500;
    }

    .frmCheckElemts {
      margin-top: 15px;
      text-align: left;
    }

    .frmCheckElemts label {
      font-size: 11px !important;
      font-weight: normal;
    }

    .m-0 {
      margin: 0 !important;
    }

    .package {
      font-family: "Roboto", sans-serif !important;
      display: flex;
    }

    .package-left, .package-right {
      width: 50%;
      position: relative;
    }

    .package-right {
      display: flex;
     }

    .d-flex {
      display: flex;
    }

    .package-name {
      font-size: 30px;
      font-weight: 600;
      margin: 0;
    }

    .box-text {
      color: #7f37a8;
    }

    .text-free {
      font-style: italic;
      font-size: 22px;
    }

    .text-bold {
      font-weight: 700;
    }

    .text-price {
      color: #359401;
      font-size: 24px;
    }

    .price-each {
      font-size: 38px;
    }

    .retail-text {
      color: #606060;
    }

    .save-label {
      width: 115px;
      height: 115px;
      background: url(assets/images/save-label.png) no-repeat;
      background-size: 100% 100%;
      position: absolute;
      top: 5px;
      right: 20px;
    }

    .save-label span {
      font-size: 16px;
      color: #fff;
      margin: 22px 0 0 9px;
      display: block;
    }

    .save-label p {
      font-size: 40px;
      color: #fff;
      margin: -4px 0 0 13px;
    }
    
    .plug-icon {
      width: 30px;
      height: 30px;
      margin: 0 20px;
    }

    .shipping-text {
      text-transform: uppercase;
      font-weight: 700;
      font-size: 14px;
    }

    .shipping-text img {
      margin: -2px 4px 0 4px;
    }

    .best-choice {
      background: url(assets/images/red-ribbon.png) no-repeat;
      background-size: 100% 100%;
      width: 94px;
      height: 35px;
      position: absolute;
      text-align: center;
      color: #fff;
      font-size: 13px;
      padding-top: 2px;
      right: -6px;
      top: 60px;
    }

    .save-block {
      background: url(assets/images/save-star.svg) no-repeat;
      background-size: 100% 100%;
      width: 100px;
      height: 100px;
      position: absolute;
      top: 5px;
      right: 20px;
      padding: 30px 0 0 0;
      text-align: center;
      font-size: 16px;
    }

    .line-break {
      height: 4px;
      background-color: #ececec;
      margin: 13px 0 12px;
    }
    
  </style>
  <?php include_once('./sentry.php'); ?>
</head>

<body class="font-sans antialiased" style="">
  <div class="relative">
    <div class="wrapper">
      <div id="app">
        <div id="ccpagepixel"></div>
        <header class="header">
          <div class="header__warning">
            <div class="container"><span class="alert-color">18 others are viewing this offer right now</span></div>
          </div>
          <div class="container row">
            <img src="assets/brand/logo2.png" width="120" alt="" class="header__logo" style="position: relative; top: -50px; left: 5px;">
            <div class="header__info row">
              <div class="delivery-block">
                <img class="unveil geo-flag" src="<?php echo $configs->root_path . "/assets/images/usa.png"; ?>" width="55" alt="">
                <p data-v-98d51d84="">Internet Exclusive Offers Available to <span class="geo-country">US</span> Residents Only</p>
              </div>
            </div>
          </div>
        </header>
        <div class="order">
          <div class="container">
            <div class="row">
              <div class="order__left">
                <div class="steps">
                  <ul class="steps__list row">
                    <li class="steps__item">1. Shipping Info</li>
                    <li class="steps__item active">2. Finish Order</li>
                    <li class="steps__item">3. Summary</li>
                  </ul>
                  <div class="approved-text"><strong data-v-98d51d84=""><span class="emphasis">APPROVED!</span> Free Bottle Packages Confirmed</strong></div>
                  <p data-v-98d51d84="">Limited supply available as of <span class="full-date date-container2 currentDateFormat"></span>. We currently have
                    product <strong data-v-98d51d84="">in stock</strong> and ready to ship within 24 hours.
                  </p>
                  <p class="status-pr">Sell Out Risk: <span data-v-98d51d84="">HIGH</span></p>
                </div>
                <div class="product-selection">
                  <div data-v-98d51d84="">
                    <div class="product product1 sel-prod active" data-pkg="5">
                      <div class="package">
                        <div class="package-left">
                          <div>
                            <h1 class="package-name">PACKAGE 1</h1>
                            <h3 class="box-text text-bold m-0">3 BOXES</h3>
                            <h3 class="text-free text-bold m-0">+ Get 2 Free!</h3>
                            <p class="text-price"><span class="price-each text-bold">$39.99</span>/box</p>
                            <p class="retail-text text-bold">Retail - <span><del>$66.66/ea</del></span></p>
                            <p>In Stock - Sell Out Risk: High</p>
                          </div>
                          <div>
                            <div class="save-label">
                              <span>SAVE OVER</span>
                              <p>50%</p>
                            </div>
                          </div>
                        </div>
                        <div class="package-right">
                          <div class="best-choice">
                            <p>BEST</p>
                            <p>CHOICE</p>
                          </div>
                          <div class="d-flex" style="align-items: center;">
                            <img src="assets/brand/product2-3.png" alt="" width="120" height="120">
                            <img src="assets/images/plus-icon.png" alt="" width="30" height="30" class="plug-icon">
                          </div>
                          <div>
                            <img src="assets/brand/product2-2.png" alt="" width="120" height="120">
                            <span class="d-flex shipping-text"><img src="assets/images/box-icon.svg" alt="" width="12" height="12"> Free shipping</span>
                          </div>
                        </div>
                      </div>
                      <!-- <div class="package-item">
                        <div class="package-item__header">
                          <div class="title-block"><span class="title-block__main">BUY 3 GET 2 FREE <span class="best-value">Best Value</span></span></div>
                          <div class="shipping-row"><span data-v-98d51d84="">FREE SHIPPING</span></div>
                        </div>
                        <div class="package-item__content">
                          <div class="package-item__status"><span data-v-98d51d84=""></span></div>
                          <div class="package-images" style="margin-bottom: 15px;">
                            <div class="package-images__item" style="align-items: center;"><img alt="" src="<?php echo $configs->root_path . "/assets/brand/product2-3.png"; ?>" style="max-height: 156px; display: block;"></div>
                            <div class="package-images__item">
                              <div class="bonus">
                                <p data-v-98d51d84="">BONUS</p>
                              </div>
                              <div class="bonus-border">
                                <div class="bonus-free flex">
                                  <div class="half">
                                    <div class="save-block">
                                      <div class="save-price"><span class="product-retail-single-price">$<span><?php echo $configs->bottle_save_5; ?></span>/each</span></div>
                                    </div>
                                    <div class="free" style="font-size: 16px;">FREE</div>
                                  </div>
                                  <div class="half" style="padding: 5px;"><img alt="" src="<?php echo $configs->root_path . "/assets/brand/product2-2.png"; ?>"></div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="package-info flex flex-col align-items-center">
                            <span class="package-info__title">5 Boxes (150 Servings)</span>
                            <span class="package-info__price"></span>
                            <span class="package-info__retail" style="margin: auto;">
                              <span class="product-single-price" style="font-size: 28px; font-weight: 800;">
                                $<span class="price sub"><?php echo $configs->bottle_per_5; ?></span>
                              </span>
                              <span style="font-size: 12px;">/per box*</span>
                            </span>
                            <span class="package-info__total"></span>
                            <span class="package-info__btn">Selected!</span>
                          </div>
                        </div>
                      </div> -->
                    </div>
                  </div>
                  <div class="line-break"></div>
                  <div data-v-98d51d84="">
                    <div class="product product1 sel-prod" data-pkg="3">
                      <div class="package">
                        <div class="package-left">
                          <div>
                            <h1 class="package-name">PACKAGE 2</h1>
                            <h3 class="box-text text-bold m-0">2 BOXES</h3>
                            <h3 class="text-free text-bold m-0">+ Get 1 Free!</h3>
                            <p class="text-price"><span class="price-each text-bold">$53.33</span>/box</p>
                            <p class="retail-text text-bold">Retail - <span><del>$79.99/ea</del></span></p>
                            <p>In Stock - Sell Out Risk: High</p>
                          </div>
                          <div>
                            <div class="save-block">
                              <span class="text-bold">SAVE</span>
                              <p>$79.99</p>
                            </div>
                          </div>
                        </div>
                        <div class="package-right">
                          <!-- <div class="best-choice">
                            <p>BEST</p>
                            <p>CHOICE</p>
                          </div> -->
                          <div class="d-flex" style="align-items: center;">
                            <img src="assets/brand/product2-2.png" alt="" width="120" height="120">
                            <img src="assets/images/plus-icon.png" alt="" width="30" height="30" class="plug-icon">
                          </div>
                          <div>
                            <img src="assets/brand/product1-1.png" alt="" width="120" height="120">
                            <span class="d-flex shipping-text"><img src="assets/images/box-icon.svg" alt="" width="12" height="12"> Free shipping</span>
                          </div>
                        </div>
                      </div>
                      <!-- <div class="package-item">
                        <div class="package-item__header">
                          <div class="title-block"><span class="title-block__main">BUY 2 GET 1 FREE <span class="most-popular">MOST POPULAR</span></span></div>
                          <div class="shipping-row"><span data-v-98d51d84="">FREE SHIPPING</span></div>
                        </div>
                        <div class="package-item__content">
                          <div class="package-item__status"><span data-v-98d51d84=""></span></div>
                          <div class="package-images" style="margin-bottom: 15px;">
                            <div class="package-images__item" style="align-items: center;"><img alt="" src="<?php echo $configs->root_path . "/assets/brand/product2-2.png"; ?>" style="max-height: 156px; display: block;"></div>
                            <div class="package-images__item">
                              <div class="bonus">
                                <p data-v-98d51d84="">BONUS</p>
                              </div>
                              <div class="bonus-border">
                                <div class="bonus-free flex">
                                  <div class="half">
                                    <div class="save-block">
                                      <div class="save-price"><span class="product-retail-single-price">$<span><?php echo $configs->bottle_save_3; ?></span>/each</span></div>
                                    </div>
                                    <div class="free" style="font-size: 16px;">FREE</div>
                                  </div>
                                  <div class="half" style="padding: 5px;"><img alt="" src="<?php echo $configs->root_path . "/assets/brand/product.png"; ?>"></div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="package-info flex flex-col align-items-center">
                            <span class="package-info__title">3 Boxes (90 Servings)</span>
                            <span class="package-info__price"></span>
                            <span class="package-info__retail" style="margin: auto;">
                              <span class="product-single-price" style="font-size: 28px; font-weight: 800;">
                                $<span class="price sub"><?php echo $configs->bottle_per_3; ?></span>
                              </span>
                              <span style="font-size: 12px;">/per box*</span>
                            </span>
                            <span class="package-info__total"></span>
                            <span class="package-info__btn">Select Package</span>
                          </div>
                        </div>
                      </div> -->
                    </div>
                  </div>

                  <div class="line-break"></div>

                  <div data-v-98d51d84="">
                    <div class="product product1 sel-prod" data-pkg="1">
                      <div class="package">
                        <div class="package-left">
                          <div>
                            <h1 class="package-name">PACKAGE 3</h1>
                            <h3 class="box-text text-bold m-0">1 BOX</h3>
                            <h3 class="text-free text-bold m-0">+ Get 1 Free!</h3>
                            <p class="text-price"><span class="price-each text-bold">$64.99</span>/box</p>
                            <p class="retail-text text-bold">Retail - <span><del>$129.99/ea</del></span></p>
                            <p>In Stock - Sell Out Risk: High</p>
                          </div>
                          <div>
                            <!-- <div class="save-block">
                              <span class="text-bold">SAVE</span>
                              <p>$79.99</p>
                            </div> -->
                          </div>
                        </div>
                        <div class="package-right">
                          <!-- <div class="best-choice">
                            <p>BEST</p>
                            <p>CHOICE</p>
                          </div> -->
                          <div class="d-flex" style="align-items: center;">
                            <img src="assets/brand/product1-1.png" alt="" width="120" height="120">
                            <img src="assets/images/plus-icon.png" alt="" width="30" height="30" class="plug-icon">
                          </div>
                          <div>
                            <img src="assets/brand/product1-1.png" alt="" width="120" height="120">
                            <span class="d-flex shipping-text"><img src="assets/images/box-icon.svg" alt="" width="12" height="12"> Free shipping</span>
                          </div>
                        </div>
                      </div>
                      <!-- <div class="package-item">
                        <div class="package-item__header">
                          <div class="title-block"><span class="title-block__main">BUY 1 GET 1 FREE</span></div>
                          <div class="shipping-row"><span data-v-98d51d84="">$9.95 SHIPPING</span></div>
                        </div>
                        <div class="package-item__content">
                          <div class="package-item__status"><span data-v-98d51d84=""></span></div>
                          <div class="package-images" style="margin-bottom: 15px;">
                            <div class="package-images__item" style="align-items: center;"><img alt="" src="<?php echo $configs->root_path . "/assets/brand/product.png"; ?>" style="max-height: 156px; display: block;"></div>
                            <div class="package-images__item">
                              <div class="bonus">
                                <p data-v-98d51d84="">BONUS</p>
                              </div>
                              <div class="bonus-border">
                                <div class="bonus-free flex">
                                  <div class="half">
                                    <div class="save-block">
                                      <div class="save-price">
                                        <span class="product-retail-single-price">$<span><?php echo $configs->bottle_save_1; ?></span>/each</span>
                                      </div>
                                    </div>
                                    <div class="free" style="font-size: 16px;">FREE</div>
                                  </div>
                                  <div class="half" style="padding: 5px;"><img alt="" src="<?php echo $configs->root_path . "/assets/brand/product.png"; ?>"></div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="package-info flex flex-col align-items-center">
                            <span class="package-info__title">2 Boxes (60 Servings)</span>
                            <span class="package-info__price"></span>
                            <span class="package-info__retail" style="margin: auto;">
                              <span class="product-single-price" style="font-size: 28px; font-weight: 800;">
                                $<span class="price sub"><?php echo $configs->bottle_per_1; ?></span>
                              </span>
                              <span style="font-size: 12px;">/per box*</span>
                            </span>
                            <span class="package-info__total"></span>
                            <span class="package-info__btn">Select Package</span>
                          </div>
                        </div>
                      </div> -->
                    </div>
                  </div>

                  <div class="line-break"></div>
                  
                  <img class="img-responsive secure-icons" src="<?php echo $configs->root_path . "/assets/images/secureicons_14.png"; ?>">
                  <div class="guarantee-block">
                    <div class="guarantee-top">30-DAYS MONEY-BACK GUARANTEE</div>
                    <div class="guarantee-content">
                      <img src="<?php echo $configs->root_path . "/assets/images/30-day-back.png"; ?>" alt="" class="guarantee-icon">
                      <div class="guarantee-text">
                        <p data-v-98d51d84="">We are so confident in our products and services, that we back it with a 30-days money-back
                          guarantee. If for any reason you are not fully satisfied with our products, simply return the
                          purchased products in the original container within 30 days of when you received your order.
                          We will refund you 100% of the purchase price - with absolutely no hassle.
                        </p>
                      </div>
                    </div>
                  </div>
                  <div class="line-block">
                    <a href="#">
                      <div class="line">
                        <div class="text-center">HURRY! CONFIRM YOUR ORDER NOW!</div>
                      </div>
                    </a>
                    <div class="arrow"></div>
                  </div>
                </div>
              </div>
              <div class="order__right" style="width: 33%;">
                <div id="payment-info" class="">
                  <div class="max-w-sm mx-auto bg-slate-100">
                    <div class="place-items-center justify-center bg-zinc-800">
                      <div>
                        <div class="md:h-16 h-23 step_text font-bold ml-3 pt-1.5 leading-6 font-helvetica text-white" style="height: 200px !important;padding:22px 0;">
                          <h1 style="font-size: 40px">FINAL STEP:</h1>
                          <h1>Choose Your Package & Complete Your Order</h1>
                          <p style="text-align: center; font-weight: 400;">You’re moments away from enjoying Hello Healthy Glucose Coffee with GlucoTrojan™ Technology.</p>
                        </div>
                      </div>
                    </div>
                    <div class="flex flex-col justify-items-center text-center font-roboto-normal">
                      <div class="h-7">
                        <h2 class="m-2 font-bold text-[#6f6c6c] font-opensans We_Accept">We Accept:</h2>
                      </div>
                      <div class="flex flex-row justify-center flex-nowrap h-12 gap-1 columns-6 place-items-center">
                        <div class="card_logo">
                          <center><img src="<?php echo $configs->root_path . "/assets/images/card.png"; ?>" style="width: 100%;"></center>
                        </div>
                      </div>
                      <form class="form-popup" id="checkout" onsubmit="return submit_form()">
                        <input type='hidden' name='token' value='<?php echo $_SESSION["token"]; ?>'>
                        <input type="hidden" name="package" value="<?php echo (isset($_SESSION["package"])) ? $_SESSION["package"] : 5; ?>" id="package">
                        <input type="hidden" name="fields_prospect_id" value="<?php echo $_GET["prospectId"]; ?>">
                        <input type="hidden" name="fields_cc_type" value="">
                        <input type="hidden" name="device" value="desktop">
                        <!-- <input type="hidden" id="product" name="product" value="5B_reg" />
                            <input type="hidden" id="product2" name="product2" value="5B" />
                            <input type="hidden" name="_token" value="9DcoRVUCHhGP9icToWNlfBz4BD0KZNxqnhc7JYdL">
                            <input type="hidden" id="method" name="method" value="NewOrderWithProspect" />
                            <input type="hidden" id="billShipSame" name="billingSameAsShipping" value="1" />
                            <input type='hidden' name='upgrade' id='upgrade' value='0'>
                            <input type='hidden' name='creditCardType' id='creditCardType' value='visa'> -->
                        <h2 class="text-left  font-[600] mt-3 pinfo px-2">Payment Information</h2>
                        <div data-v-d70e9656="" class="form-group col-span-12 relative text-left p-2" style="margin-top: 1em;">
                          <label data-v-d70e9656="" for="card_number" class="text-sm" style="font-size: 0.75em; font-weight: 400; ;">Card Number:</label>
                          <div data-v-d70e9656="" class="relative">
                            <input type="tel" name="fields_cc_number" class="required w-full border-1 border-gray-300 focus:border-[#51cbee] focus:ring focus:ring-blue-200 focus:ring-opacity-50 rounded-md shadow-sm read-only:bg-gray-200 read-only:border-gray-200 read-only:ring-gray-200" id="cardNumber" placeholder="Card Number" style="border: 1px solid gray;" type="tel" maxlength="16" placeholder="•••• •••• •••• ••••">
                          </div>
                        </div>
                        <p class="text-red-500 font-bold my-2 text-[0.8em] leading-[1.2em] text-left px-4"></p>
                        <div class="flex flex-col mt-3 px-2">
                          <label for="card_number" class="text-left text-xs">Card Expiry Date:</label>
                          <div class="flex space-x-4 relative">
                            <div class="w-1/2 relative">
                              <div data-v-82f35cc0="" class="form-group col-span-12">
                                <div data-v-82f35cc0="" class="relative">
                                  <select name="fields_expmonth" class="required bg-white border-gray-300 focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 rounded-md shadow-sm w-full shadow h-[42.6px] flex-1 w-full rounded" data-error-message="Please select a valid expiry month!" id="fields_expmonth" style="padding-bottom: 1px; padding-top: 1px; border: 1px solid gray;" data-threeds="month">
                                    <option value="">Month</option>
                                    <option value="01">(01) January</option>
                                    <option value="02">(02) February</option>
                                    <option value="03">(03) March</option>
                                    <option value="04">(04) April</option>
                                    <option value="05">(05) May</option>
                                    <option value="06">(06) June</option>
                                    <option value="07">(07) July</option>
                                    <option value="08">(08) August</option>
                                    <option value="09">(09) September</option>
                                    <option value="10">(10) October</option>
                                    <option value="11">(11) November</option>
                                    <option value="12">(12) December</option>
                                  </select>
                                </div>
                              </div>
                            </div>
                            <div class="w-1/2 relative">
                              <div data-v-82f35cc0="" class="form-group col-span-12">
                                <div data-v-82f35cc0="" class="relative">
                                  <select name="fields_expyear" class="required bg-white border-gray-300 focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 rounded-md shadow-sm w-full shadow h-[42.6px] flex-1 w-full rounded" data-error-message="Please select a valid expiry year!" id="fields_expyear" style="padding-bottom: 1px; padding-top: 1px; border: 1px solid gray;" data-threeds="year">
                                    <option value="Year" selected="selected">Year</option>
                                    <option value="24">2024</option>
                                    <option value="25">2025</option>
                                    <option value="26">2026</option>
                                    <option value="27">2027</option>
                                    <option value="28">2028</option>
                                    <option value="29">2029</option>
                                    <option value="30">2030</option>
                                    <option value="31">2031</option>
                                    <option value="32">2032</option>
                                    <option value="33">2033</option>
                                    <option value="34">2034</option>
                                    <option value="35">2035</option>
                                    <option value="36">2036</option>
                                    <option value="37">2037</option>
                                    <option value="38">2038</option>
                                  </select>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="flex flex-col mt-3 px-2">
                          <label for="cvv" class="text-left text-xs">CVV:</label>
                          <div class="flex space-x-4">
                            <div data-v-0bda78a8="" class="form-group col-span-12 focus:outline-none basis-1/2 text-left">
                              <div data-v-0bda78a8="" class="relative">
                                <input type="tel" name="fields_cvv" class="required w-full border-2 border-gray-300 focus:border-[#51cbee] focus:ring focus:ring-blue-200 focus:ring-opacity-50 rounded-md shadow-sm read-only:bg-gray-200 read-only:border-gray-200 read-only:ring-gray-200 shadow flex-1 w-full rounded" data-validate="cvv" maxlength="4" data-error-message="Please enter a valid CVV code!" onKeyUp="javascript: this.value = this.value.replace(/[^0-9]/g, '');" id="cc_cvv" placeholder="CVV" style="border: 1px solid gray;">
                              </div>
                            </div>
                            <div class="basis-1/2 underline text-sm text-left cursor-pointer flex flex-col justify-center text-slate-400">
                              <p class="text-grey-700 font-[400]"><a href="javascript:void(0);" onclick="openNewWindow('assets/images/cvv-image.png','modal');">Where can I find my Security Code?</a></p>
                            </div>
                          </div>
                        </div>
                        <div class="flex flex-row justify-center mt-3"><img id="secure-lock" src="<?php echo $configs->root_path . "/assets/images/lock-img.svg"; ?>" class="w-2.5 h-2.5 mt-0.5" alt="href"><label for="secure-lock" class="ml-2 text-xs">Secure 256-bit SSL Encryption</label></div>
                        <div>
                          <div class="h-20 mt-3 ml-2 mr-2 mb-2 rounded-[5px] from-amber-300 to-amber-500 bg-gradient-to-b">
                            <div class="text-white text-xl relative place-items-center">
                              <button type="submit" id="formSubmit" class="h-20 font-medium indent-[10px] leading-[1.15] text-[22px] font-roboto-normal form-submit-button">YES! COMPLETE MY ORDER</button>
                            </div>
                          </div>
                          <div style="padding: 10px;">
                            <div style="margin-top: 20px;padding: 3px;border-radius: 3px;">
                              <img src="./assets/images/sec-logos.png" alt="">
                            </div>
                          </div>
                          <div class="frmCheckElemts" style="padding: 20px 10px 0;">
                            <label class="spl-checkbox" style="vertical-align:top;text-align: left;font-size: 10px !important;">
                              <input type="checkbox" name="emag_subscription" id="emag_subscription" value="Y" checked="checked" class="chkbox no-error" style="">
                              <span>As a special gift you will gain access to the Health Digital Magazine Series today for the discounted rate of only $19.93 monthly. For questions on this separate enrollment, call any time.</span>
                            </label>
                          </div>
                        </div>
                        <div class="mt-3 mb-4"></div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <style>
          .product-selection .product1>* {
            pointer-events: none;
          }
        </style>
        <div class="modal fade modal-lg" id="upsellModal" tabindex="-1" role="dialog" aria-labelledby="upsellModal" data-bs-backdrop="static" data-bs-keyboard="false" aria-modal="true" style="display: none; background: none; justify-content: center; align-items: center; margin: 0 auto; flex-direction: column; top: 0; bottom: 0; left: 0; right: 0;">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-body upsell-modal-body">
                <div class="container-fluid position-relative">
                  <div class="row2">
                    <div class="col-lg-5 col-12 text-center d-flex justify-content-center align-items-center">
                      <div class="pt-3 pb-4 upsellModal-product-image m-auto">
                        <img src="<?php echo $configs->root_path . "/assets/brand/product2-5.png"; ?>" class="img-fluid" id="product5B" style="display: none">
                        <img src="<?php echo $configs->root_path . "/assets/brand/product2-3.png"; ?>" class="img-fluid" id="product3B" style="display: none">
                        <img src="<?php echo $configs->root_path . "/assets/brand/product2-2.png"; ?>" class="img-fluid" id="product2B" style="display: none">
                      </div>
                    </div>
                    <div class="col-lg-7 col-12 text-center d-flex flex-column justify-content-end pb-3">
                      <h2 class="mb-2">Exclusive offer</h2>
                      <h1 class="mb-4">
                        <b style="color: #ffd900">
                          DOUBLE <br> YOUR VALUE!
                        </b>
                      </h1>
                      <h5 class="mb-1">
                        Upgrade from 500MG (20 gummies/ bottle) <br>
                      </h5>
                      <h4 class="mb-5">
                        <b>to 1000MG (40 gummies/ bottle) </b><br>
                      </h4>
                      <h5 class="mb-0">
                        <small class="unimportant">For Only <span class="small-price">$9.99</span> More Per Box</small>
                      </h5>
                    </div>
                    <div class="col-12 text-center">
                      <button class="send-btn mb-3 btn_pulse" id="upsellAccept" data-value="5B">
                        COMPLETE CHECKOUT
                      </button>
                      <button class="send-btn-secondary" id="upsellDecline">
                        NO, THANK YOU
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-backdrop fade show" style="display: none;"></div>
        <input type="hidden" id="ccchecker" name="" value="">
        <footer class="footer">
          <div class="container">
            <ul class="footer-part row">
              <li data-v-98d51d84="">
                <div class="footer-part__img"><img src="<?php echo $configs->root_path . "/assets/images/3438e78baf8f591abf6e4f97252d628f.svg"; ?>" alt=""></div>
                <p data-v-98d51d84="">Highest Security Levels for Online Transactions 256 bit Encryption.</p>
              </li>
              <li data-v-98d51d84="">
                <div class="footer-part__img"><img src="<?php echo $configs->root_path . "/assets/images/8c7180b8e8bc8c7da69efc054d54cedc.svg"; ?>" alt=""></div>
                <p data-v-98d51d84="">Your Privacy Protected Rest Assured.</p>
              </li>
              <li data-v-98d51d84="">
                <div class="footer-part__img"><img src="<?php echo $configs->root_path . "/assets/images/a2ca92e9b8b550f5609b07caa9fdd0d3.svg"; ?>" alt="" style="width: 70px; height: 50px;"></div>
                <p data-v-98d51d84="">100% Consumer Satisfaction Guaranteed.</p>
              </li>
              <li data-v-98d51d84="">
                <div class="footer-part__img"><img src="<?php echo $configs->root_path . "/assets/images/2d1c0717ba8a5998dcfa51a9a937b079.svg"; ?>" alt=""></div>
                <p data-v-98d51d84="">Award Winning Customer Service.</p>
              </li>
            </ul>
            <p data-v-98d51d84="">*Prices indicated on the website are the average price per box for the total number of boxes in each
              package.
            </p>
            <p data-v-98d51d84="">We are committed to maintaining the highest quality products and the utmost integrity in business
              practices. All products sold on this website are produced in a Good Manufacturing Practices (GMP), which is
              the highest standard of testing in the supplement industry.<br data-v-98d51d84="">Notice: This product has not been evaluated by the FDA. Products and statements have not been evaluated by
              the European Medicines Agency or Food and Drug Administration. This product is not intended to diagnose,
              treat, cure or prevent any disease. <br data-v-98d51d84="">Results in description and testimonials may not be typical results and individual results may vary.
            </p>
            <ul data-v-98d51d84="" class="terms-links">
              <li>
                <a href="javascript:void(0);" class="modal-link cursor-pointer" onclick="openNewWindow('./disclosures/terms.php','modal');">Terms &amp; Conditions</a>
              </li>
              <li>
                <a href="javascript:void(0);" class="modal-link cursor-pointer" onclick="openNewWindow('./disclosures/privacy.php','modal');">Privacy Policy</a>
              </li>
              <li>
                <a href="javascript:void(0);" class="modal-link cursor-pointer" onclick="openNewWindow('./disclosures/contact.php','modal');">Contact Us</a>
              </li>
            </ul>
            <p data-v-98d51d84="">Copyright © <script type="text/javascript">
                var year = new Date();
                document.write(year.getFullYear());
              </script> ShopJBA, All Rights Reserved.</p>
          </div>
        </footer>
      </div>
    </div>
  </div>

  <!--popup processing wrapper-->
  <section id="loading-indicator" class="popup-loading-wrapper" style="display: none">
    <div class="popup">
      <img src="<?php echo $configs->root_path . "/assets/images/icon-lock.png"; ?>" alt="" class="lock-image" />
      <p>Please wait a moment</p>
      <h3>Your Product Is Being Reserved</h3>
      <img src="<?php echo $configs->root_path . "/assets/images/icon-loading.png"; ?>" alt="" class="loading-image" />
    </div>
  </section>
  <!--end popup processing wrapper-->

  <script src="<?php echo $configs->root_path . "/assets/js/jquery.min.js"; ?>"></script>
  <script src="<?php echo $configs->root_path . "/assets/js/jquery.mask.min.js"; ?>"></script>
  <script src="<?php echo $configs->root_path . "/assets/js/threeds.2.min.latest.js"; ?>"></script>
  <script type="text/javascript" src="<?php echo $configs->root_path . "/assets/js/jquery.cardtype.js"; ?>"></script>
  <script>
    /* $('#product').val('5B_sub');
    $('#product2').val('5B'); */

    const formatedDate = new Date().toLocaleString('en-us', {
      month: 'long',
      year: 'numeric',
      day: 'numeric'
    });
    $('.currentDateFormat').text(formatedDate);

    $('#cardNumber').keyup(function() {
      const result = $('#cardNumber').validateCreditCard();

      if (result.card_type && result.card_type.name) {
        let card = result.card_type.name;

        card = card.replace("mastercard", "master");

        $("input[name=fields_cc_type]").val(card);
      }
    });

    $('.sel-prod').on('click', function() {
      $(".sel-prod .package-info__btn").text('Select Package');
      $(".sel-prod").removeClass("active");
      $(this).addClass("active");
      $(this).find('.package-info__btn').text("Selected!");
      $("input[name=package]").val($(this).data('pkg'));

      /*if ($(this).data('bundle') == "5x") {
        $("#product2").val("5B")
      } else if ($(this).data('bundle') == "3x") {
        $("#product2").val("3B")
      } else if ($(this).data('bundle') == "2x") {
        $("#product2").val("2B")
      }*/
      $('html, body').animate({
        scrollTop: "120px"
      }, "slow");
    })

    /* // Change card type
    $('input[name="cardNumber"]').on('input', function() {
      updateCard();
    });

    $('input[name="cardNumber"]').mask('0000 0000 0000 0000');


    function updateCard() {
      var value = $('input[name="cardNumber"]').val();
      value = value.replace(/-/g, "");
      $('#ccchecker').val(value);
      var name = '';
      if (value.length < 4) return;
      const result = $('#ccchecker').validateCreditCard();
      if (result.card_type != null) {
        name = result.card_type.name;
      }
      switch (name) {
        case 'visa':
          $('#credit_card_type').val('visa');
          break;
        case 'mastercard':
          $('#credit_card_type').val('master');
          break;
        case 'discover':

          $('#credit_card_type').val('discover');
          break;
        case 'amex':
          $('#credit_card_type').val('amex');
          break;
        default:
          $('#credit_card_type').val('visa');
          break;
      }
    } */

    function submit_form() {
      $("#proc_popup").show();
      var errors = new Array();

      // Check CC #
      if ($("#cardNumber").val() === "") {
        errors.push("Please enter a credit card number.");
      } else {
        /*
        var valid = LuhnAlgorithm($('#cardNumber').unmask().val());
        
        if (!valid) {
            errors.push("Invalid credit card number.");
        }
        */
      }

      if ($("#fields_expmonth").val() === "" || $("#fields_expmonth").val() === "Month") {
        errors.push("Please enter a valid expiration month.");
      }

      if ($("#fields_expyear").val() === "" || $("#fields_expyear").val() === "Year") {
        errors.push("Please enter a valid expiration year.");
      }

      if ($("#fields_cvv").val() === "") {
        errors.push("Please enter a CVV code.");
      }

      if (errors.length == 0) {
        /* $('.loading-screen .show-1, .loading-screen .show-2, .loading-screen .show-3, .loading-screen .show-4').removeClass("active");
        $('.loading-screen').show();

        setTimeout(function() {
            $('.loading-screen .show-1').addClass("active");
        }, 500);

        setTimeout(function() {
            $('.loading-screen .show-2').addClass("active");
        }, 2000);

        setTimeout(function() {
            $('.loading-screen .show-3').addClass("active");
        }, 3000); */

        $('#loading-indicator').css('display', 'block');

        var data = $("#checkout :input[value!=''][value!='.']").serialize();
        $.ajax({
          type: "POST",
          url: "./app/src/create_order.php",
          data: data,
          success: function(result) {
            var response = result.split("|");
            if (response[0] == "ok") {
              window.location.href = response[1];
            } else {
              $('#loading-indicator').css('display', 'none');
              // $(".loading-screen").hide();
              popErrorModal(response[1]);
            }
          },
          error: function() {
            $('#loading-indicator').css('display', 'none');
            // $(".loading-screen").hide();
          }
        });

        $('#cardNumber').mask("0000 0000 0000 0000");
        return false;
      } else {
        $('#cardNumber').mask("0000 0000 0000 0000");
        var li = '';
        $.each(errors, function(key, value) {
          li += '<li>' + value + '</li>';
        });

        var html = '';
        html += '<div id="error_handler_overlay">';
        html += '<div class="error_handler_body"><a href="javascript:void(0);" id="error_handler_overlay_close">X</a><ul>' + li + '</ul></div>';
        html += '</div>';

        $('body').append(html);
        $("#proc_popup").hide();

        $('#error_handler_overlay').fadeIn(500);
        return false;
      }

      return false;
    }

    function popErrorModal(errors) {
      var li = '';
      if (errors == "Order is already completed") {
        li = '<li>' + errors + '</li>';
      } else if (typeof errors === 'string') {
        li = '<li>' + errors + '</li>';
      } else {
        $.each(errors, function(key, value) {
          li += '<li>' + value + '</li>';
        });
      }

      var html = '';
      html += '<div id="error_handler_overlay">';
      html += '<div class="error_handler_body"><a href="javascript:void(0);" id="error_handler_overlay_close">X</a><ul>' + li + '</ul></div>';
      html += '</div>';

      $('body').append(html);
      $("#proc_popup").hide();

      $('#error_handler_overlay').fadeIn(500);
      return false;
    }

    jQuery(function($) {
      $(".cvv-link").click(function() {
        $('.cvv-image').show();
      });
    });

    $(window).on('load', function() {
      var $preloader = $('#preloader');
      var $preloader2 = $('#popup-loading-wrapper2');
      $preloader.delay(500).fadeOut('slow');
      $preloader2.delay(500).fadeOut('slow');
    });

    $(function() {
      $(window).keydown(function(e) {
        if (e.which === 27 && $('#error_handler_overlay').length) {
          $('#error_handler_overlay').remove();
        }
      });

      $(document).off('click', '#error_handler_overlay');
      $(document).on('click', '#error_handler_overlay', function() {
        $(this).remove();
      });

      $(document).off('click', '#error_handler_overlay_close');
      $(document).on('click', '#error_handler_overlay_close', function() {
        $('#error_handler_overlay').remove();
      });

      $(document).on('click', '#app_common_modal_close', function() {
        $('#app_common_modal').remove();
      });
    });

    $(document).ready(function() {
      $("#cardNumber").mask("0000 0000 0000 0000");
    });

    function openNewWindow(page_url, type, window_name, width, height, top, left, features) {
      if (!type) {
        type = 'popup';
      }
      if (!width) {
        width = 480;
      }
      if (!height) {
        height = 480;
      }
      if (!top) {
        top = 50;
      }
      if (!left) {
        left = 50;
      }
      if (!features) {
        features = 'resizable,scrollbars';
      }

      if (type == 'popup') {
        var settings = 'height=' + height + ',';
        settings += 'width=' + width + ',';
        settings += 'top=' + top + ',';
        settings += 'left=' + left + ',';
        settings += features;

        win = window.open(page_url, window_name, settings);
        win.window.focus();
      } else if (type == 'modal') {
        var html = '';
        html += '<div id="app_common_modal">';
        html += '<div class="app_modal_body"><a href="javascript:void(0);" id="app_common_modal_close">X</a><iframe src="' + page_url + '" frameborder="0"></iframe></div>';
        html += '</div>';

        if (!$('#app_common_modal').length) {

          $('body').append(html);
        }
        $('#app_common_modal').fadeIn();
      }

    }

    function GetCardType(number) {
      // visa
      var re = new RegExp("^4");
      if (number.match(re) != null)
        return "visa";

      // Mastercard 
      // Updated for Mastercard 2017 BINs expansion
      if (/^(5[1-5][0-9]{14}|2(22[1-9][0-9]{12}|2[3-9][0-9]{13}|[3-6][0-9]{14}|7[0-1][0-9]{13}|720[0-9]{12}))$/.test(number))
        return "master";

      // AMEX
      re = new RegExp("^3[47]");
      if (number.match(re) != null)
        return "amex";

      // Discover
      re = new RegExp("^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)");
      if (number.match(re) != null)
        return "discover";

      // Diners
      re = new RegExp("^36");
      if (number.match(re) != null)
        return "diners";

      // Diners - Carte Blanche
      re = new RegExp("^30[0-5]");
      if (number.match(re) != null)
        return "diners";

      // JCB
      re = new RegExp("^35(2[89]|[3-8][0-9])");
      if (number.match(re) != null)
        return "jcb";

      // Visa Electron
      re = new RegExp("^(4026|417500|4508|4844|491(3|7))");
      if (number.match(re) != null)
        return "none";

      return "";
    }

    var tds = new ThreeDS(
      "checkout",
      "466fc6ab1f21ddc5080cfbb1e8aac3e0",
      null, {
        endpoint: "https://api.3dsintegrator.com/v2",
        autoSubmit: false,
        verbose: true
      });

    var tds_rebill = new ThreeDS(
      "checkout",
      "466fc6ab1f21ddc5080cfbb1e8aac3e0",
      null, {
        endpoint: "https://api.3dsintegrator.com/v2",
        autoSubmit: false,
        verbose: true
      });

    function get_3ds_tokens() {
      console.log("3ds verify!");

      tds.verify(function(response) {
        console.log("Accepted");
        console.log(response);
      }, function(reject) {
        console.log("Rejected");
        console.log(reject);
      }, {
        amount: 20
      });

      tds_rebill.verify(function(response) {
        console.log("Accepted");
        console.log(response);
      }, function(reject) {
        console.log("Rejected");
        console.log(reject);
      }, {
        amount: 20
      });
    }
  </script>
  <?php Pixel::render('glucovita-v1', ['payment']);?>
</body>

</html>