<?php
include("_global.php");

if (!isset($_SESSION['token'])) {
    $_SESSION['token'] = generate_csrf_token();
}

if ($mobile_detect->isMobile() && !$mobile_detect->isTablet()) {
    $url = $configs->mobile_path . "?" . $_SERVER['QUERY_STRING'];
    header("Location: $url");
}

?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?php echo $configs->page_title; ?></title>
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" type="text/css" href="assets/css/style9.css">
	<link rel="stylesheet" type="text/css" href="assets/css/common.css">
	<link rel="shortcut icon" type="/assets/image/x-icon" href="<?php echo $configs->root_path . "/assets/brand/favicon.png"; ?>">
	<?php include_once('./sentry.php'); ?>
	
</head>

<body class="">
	<div id="wrapper">
		<!-- <div class="page-top">
			<div class="container">
				<p class="p1-pgtop"><span class="span1">WARNING:</span> Due to extremely high media demand, there is limited supply of <span class="span1"><?php echo $configs->step1_name; ?></span> in stock as of <span class="span1 date-container"> February 26, 2024</span></p>
			</div>
		</div> -->
		<!--================-->
		<div class="banner-hm">
			<div class="container">
				<div class="bnrhm-lft a1">
					<div class="bnrhm-lft-in1">
						<img src="assets/brand/logo.png" class="logo">
					</div>
					<img src="assets/images/p1img-bnr.png" class="p1img-bnr bpimg">
					<p class="p-custom">Infused with <?php echo $configs->step1_name; ?>: Reducose®, ABALife™, & Trojan22® Blend for lasting energy without the crash.</p>
					<p class="p2-bnrhm">Safely &amp; Naturally</p>
					<p class="p3-bnrhm assets" style="font-size: 14px;">Turn Fast Carbs into Slow Energy With <br />GlucoTrojan™</p>
					<p class="p4-bnrhm">The Coffee That Helps Block Sugar Spikes					</p>
					<ul class="points-bnrhm pointsdiv">
						<li><span>Helps</span> maintain healthy blood sugar levels naturally.</li>
						<li><span>Blocks</span> starch & sugar absorption before meals.</li>
						<li><span>Improves</span> energy & focus without sugar crashes.</li>
						<li><span>Supports</span> healthy cholesterol & insulin sensitivity.</li>
						<li>Power by <span><?php echo $configs->step1_name; ?></span>— clinically studied ingredients.</li>
					</ul>
					<span><img src="assets/images/stars5.png" class="" width="100px">  — Thousands of customers love their results.</span>
					<img src="assets/images/arwtxt-bnr.png" class="arwtxt-bnr bpimg2">
					<!-- <img src="assets/brand/prod-bnr.png" class="prod-bnr assets" width="350"> -->
					<!-- <img src="assets/images/shp2-sec1.png" class="prod-bnr-add"> -->
					<div class="rvw-no" id="fades">
						<p class="p5-bnrhm" style="display: block; opacity: 0.5;"><img src="assets/images/eye-bnr.png" class="eye-bnr">13 others are viewing this offer right now!</p>
						<p class="p5-bnrhm" style="display: none;"><img src="<?php echo $configs->root_path . "/assets/images/eye-bnr.png"; ?>" class="eye-bnr">25 people bought this in the last hour!</p>
					</div>
				</div>
				<!---------------------->
				<div class="bnrhm-rgt" id="formid">
					<!-- <p class="p6-bnrhm"><img src="<?php echo $configs->root_path . "/assets/images/flag-US.png"; ?>" class="flag-bnrhm"><span>Internet Exclusive Offer Available to <span id="fields_state_text">American</span> Residents Only</span></p> -->
					<div class="formdiv-bnrhm">
						<div class="formdiv-bnrhm-top">
							<h2 style="color:#f1ba10;">Reserve Your <br />Discounted Box Today</h2>
							<p class="text-white">Complete the form below to <br />secure your order.</p>
							<!-- <h2 style="color: white;">ABOUT YOURSELF</h2> -->
						</div>
						<div class="form-bnrhm">
						<form class="form123" id="theForm" method="POST" action="./app/src/create_prospect.php" onSubmit="return validate_optin_form()">
							<input type='hidden' name='token' value='<?php echo $_SESSION["token"]; ?>'>
							<input type="hidden" name="device" value="desktop">
							<input type="hidden" name="pk" value="5">
							<input type="hidden" name="shipCountry" value="US">
							<?php
							foreach ($_GET as $key => $value) {
								echo "<input type='hidden' name='" . safeRequest($key) . "' value='" . safeRequest($_GET[$key]) . "'>";
							}
							?>
							<div class="form-holder">
								<input type="text" class="form-control required" data-placement="auto left" placeholder="First Name" name="fields_fname" id='fields_fname'>
							</div>
							<div class="form-holder">
								<input type="text" class="form-control required" data-placement="auto left" placeholder="Last Name" name="fields_lname" id='fields_lname'>
							</div>
							<div class="form-holder">
								<input type="email" class="form-control required" data-placement="auto left" placeholder="Email" name="fields_email" id="fields_email">
							</div>
							<div class="form-holder">
								<input type="tel" class="form-control required" data-placement="auto left" placeholder="Phone Number" name="fields_phone" id="fields_phone">
							</div>
							<div class="form-holder">
								<input type="text" class="form-control required" data-placement="auto left" placeholder="Address" name="fields_address1" id="fields_address1">
							</div>
							<div class="form-holder">
								<input type="text" class="form-control required" data-placement="auto left" placeholder="City" name="fields_city" id="fields_city">
							</div>
							<div class="form-holder">
								<select name="fields_state" id="fields_state" class="form-control required" data-selected="" data-error-message="State is required">
									<option value="" onClick="">Select State</option>
									<option value="AL">Alabama (AL)</option>
									<option value="AK">Alaska (AK)</option>
									<option value="AS">American Samoa (AS)</option>
									<option value="AZ">Arizona (AZ)</option>
									<option value="AR">Arkansas (AR)</option>
									<option value="AE">Armed Forces (AE)</option>
									<option value="AA">Armed Forces Americas (AA)</option>
									<option value="AP">Armed Forces Pacific (AP)</option>
									<option value="CA">California (CA)</option>
									<option value="CO">Colorado (CO)</option>
									<option value="CT">Connecticut (CT)</option>
									<option value="DE">Delaware (DE)</option>
									<option value="DC">District of Columbia (DC)</option>
									<option value="FM">Federated States of Micronesia (FM)</option>
									<option value="FL">Florida (FL)</option>
									<option value="GA">Georgia (GA)</option>
									<option value="GU">Guam (GU)</option>
									<option value="HI">Hawaii (HI)</option>
									<option value="ID">Idaho (ID)</option>
									<option value="IL">Illinois (IL)</option>
									<option value="IN">Indiana (IN)</option>
									<option value="IA">Iowa (IA)</option>
									<option value="KS">Kansas (KS)</option>
									<option value="KY">Kentucky (KY)</option>
									<option value="LA">Louisiana (LA)</option>
									<option value="ME">Maine (ME)</option>
									<option value="MD">Maryland (MD)</option>
									<option value="MA">Massachusetts (MA)</option>
									<option value="MI">Michigan (MI)</option>
									<option value="MN">Minnesota (MN)</option>
									<option value="MS">Mississippi (MS)</option>
									<option value="MO">Missouri (MO)</option>
									<option value="MT">Montana (MT)</option>
									<option value="NE">Nebraska (NE)</option>
									<option value="NV">Nevada (NV)</option>
									<option value="NH">New Hampshire (NH)</option>
									<option value="NJ">New Jersey (NJ)</option>
									<option value="NM">New Mexico (NM)</option>
									<option value="NY">New York (NY)</option>
									<option value="NC">North Carolina (NC)</option>
									<option value="ND">North Dakota (ND)</option>
									<option value="MP">Northern Mariana Islands (MP)</option>
									<option value="OH">Ohio (OH)</option>
									<option value="OK">Oklahoma (OK)</option>
									<option value="OR">Oregon (OR)</option>
									<option value="PA">Pennsylvania (PA)</option>
									<option value="MH">Republic of Marshall Islands (MH)</option>
									<option value="RI">Rhode Island (RI)</option>
									<option value="SC">South Carolina (SC)</option>
									<option value="SD">South Dakota (SD)</option>
									<option value="TN">Tennessee (TN)</option>
									<option value="TX">Texas (TX)</option>
									<option value="UT">Utah (UT)</option>
									<option value="VT">Vermont (VT)</option>
									<option value="VI">Virgin Islands of the U.S. (VI)</option>
									<option value="VA">Virginia (VA)</option>
									<option value="WA">Washington (WA)</option>
									<option value="WV">West Virginia (WV)</option>
									<option value="WI">Wisconsin (WI)</option>
									<option value="WY">Wyoming (WY)</option>
								</select>
							</div>
							<div class="form-holder">
								<input type="text" placeholder="Zipcode" class="form-control required" data-placement="auto left" type="tel" minlength="5" maxlength="5" name="fields_zip" id="fields_zip">
							</div>
							<input id="partialSubmit" class="btn-bnrhm pulse" src="assets/images/btn-ordr2.png" type="image">
							<img src="assets/images/mcfee.png" class="security-bnrhm">
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!--========section1========-->
	<div class="section1" id="content-assets">
		<div class="container">
			<div class="sec1-in">
				<p class="hdng1 p1-sec1">Do You Struggle <br>With Any of the Following?</p>
				<div class="points1-sec1">
					<img src="assets/images/img-points1-sec1.png" class="img-points1-sec1">
					<ul>
						<li>Do you crash and feel drained after meals?</li>
						<li>Have you been told you're insulin resistant or prediabetic?</li>
						<li>Struggling with stubborn belly fat that just won't go away?</li>
						<li>Is your blood sugar or A1C creeping higher each year?</li>
					</ul>
				</div>
				<p class="p2-sec1"><span class="span1">If you answered <span class="span2">"Yes"</span>to any of these questions...</span>
					<b><?php echo $configs->step1_name; ?> </b> May Help
					<span class="span3"><span class="span4">Healthy Blood Sugar</span> &amp; Reduce Glucose Spikes, <span class="span4">and Improve Metabolic Health</span> — Naturally.</span>
				</p>
				<div class="sec1-in1">
					<p class="hdng1 p3-sec1"><span class="span1">Introducing </span> <?php echo $configs->step1_name; ?> </p>
					<div class="hdngbrdrdiv hdngbrdrdiv-sec1"><img src="assets/images/shp-hdngbrdr.png" class="shp-hdngbrdr shp1-hdngbrdr"></div>
					<p class="p4-sec1"><b> <?php echo $configs->step1_name; ?> </b> contain a proprietary blend of some of the most well-known ingredients for improving blood sugar and reducing the risk of Type 2 Diabetes. It truly is a revolutionary blend utilizing the specific combination of ingredients and herbs to formulate this cutting edge formula.<br><br>
					Infused with a patented blend of <b>Reducose® White Mulberry Leaf Extract, ABALife™ Fig Extract,</b> and the exclusive <b>Trojan22® metabolic blend</b>, this unique formula delivers targeted support in one delicious, easy-to-take cup.
					</p>
					<p class="p5-sec1"><span>Triple Action Formula</span> <br>Supports Metabolic Health from the First Sip</p>
					<div class="points2-sec1">
						<ul>
							<li>Helps Manage Blood Sugar & Insulin Resistance</li>
							<li>Blocks Enzymes That Break Down Starches into Sugar</li>
							<li>Promotes Healthy Weight, Energy & Glucose Balance</li>
						</ul>
					</div>
					<img src="assets/brand/prod-bnr.png" class="prod-sec1" width="363">
					<img src="assets/images/shp1-sec1.png" class="shp1-sec1">
				</div>
			</div>
		</div>
	</div>

	<div id="content-mobile">
		<div class="sec2-bg">
			<p class="s2-hdg">Do You Suffer From Any of The Following Symptoms</p>
			<img src="<?php echo $configs->root_path . "/assets/images/comn-hdg-bar.png"; ?>" alt="" class="comn-hdg-bar">
			<ul class="s2-list">
				<li class="smallerFont">
					<img src="<?php echo $configs->root_path . "/assets/images/sec2-list-img1.png"; ?>" alt="" class="oldpplImgs">
					Do you crash and feel drained after meals?
				</li>
				<li class="smallerFont">
					<img src="<?php echo $configs->root_path . "/assets/images/sec2-list-img2.png"; ?>" alt="" class="oldpplImgs">
					Have you been told you're insulin resistant or prediabetic?
				</li>
				<li class="smallerFont">
					<img src="<?php echo $configs->root_path . "/assets/images/sec2-list-img3.png"; ?>" alt="" class="oldpplImgs">
					Struggling with stubborn belly fat that just won't go away?
				</li>
				<li class="smallerFont">
					<img src="<?php echo $configs->root_path . "/assets/images/sec2-list-img4.png"; ?>" alt="" class="oldpplImgs">
					Is your blood sugar or A1C creeping higher each year?
				</li>
			</ul>
		</div>

		<div class="sec3-bg">
			<img src="<?php echo $configs->root_path . "/assets/images/sec3-bar.png"; ?>" alt="" class="sec3-bar">
			<p class="sec3-txt1">If you answered <span>"Yes"</span> to any of these questions! </p>
			<p class="sec3-txt2"><strong>Blood Balance Advanced Formula</strong> Can Reduce Your <strong><span>Blood Pressure</span> &amp; Help You <span>Lose Excess Weight</span> Fast &amp; Effectively!</strong> </p>
			<p class="comn-hdg"><span>Introducing</span><br>Blood Balance Advanced Formula</p>
			<img src="<?php echo $configs->root_path . "/assets/images/comn-hdg-bar.png"; ?>" alt="">
			<div class="sec3-img">
				<img src="<?php echo $configs->root_path . "/assets/images/sec3-img.png"; ?>" alt="" width="297">
			</div>
			<p class="comn-txt">The <strong> Blood Balance Advanced Formula</strong> is a never before seen revolutionary formula to manage blood pressure and blood sugar levels better than any other product in the marketplace. Simply put, you will never see another product like this out there.<br><br>
				We've sourced the most rare 100% natural ingredients that have been scientifically PROVEN to manage high blood pressure and promote overall healthy blood levels, and combined them into a breakthrough formula that is now going viral.</p>
			<p class="sec3-txt3"><span>Triple Action Formula</span><br>Supports Metabolic Health from the First Sip</p>
			<ul class="sec3-list">
				<li>Helps Manage Blood Sugar & Insulin Resistance</li>
				<li>Blocks Enzymes That Break Down Starches into Sugar</li>
				<li>Promotes Healthy Weight, Energy & Glucose Balance</li>
			</ul>
		</div>
	</div>
	<!--========cta========-->
	<div class="cta" id="content-assets">
		<div class="container">
			<div class="cta-in">
				<img src="assets/brand/prod-bnr-btm2.png" class="" width="180" style="margin-right: 20px;">
				<div class="cta-lft">
					
					<p class="p1-cta"><span>Ready to Take Control</span> of Your Blood Sugar — One Cup at a Time??</p>
					<p class="p2-cta">
						Enjoy the delicious taste of Hello Healthy Glucose Coffee, powered by <?php echo $configs->step1_name; ?> Technology — to help support healthy glucose, steady energy, and balanced metabolism.
					</p>
				</div>
				<a href="#formid"><img src="assets/images/btn-ordr.png" class="btn-ordr-cta pulse"></a>
			</div>
		</div>
	</div>
	<div class="strip" id="content-mobile">
		<p class="strip-txt1"><span>Are You Ready</span><br>To Restore Your Health?</p>
		<p class="strip-txt2">Feel the difference Blood Balance Advanced Formula makes!</p>
	</div>
	<!--========section2========-->
	<div class="section2" id="content-assets">
		<div class="container">
			<div class="sec2-in">
				<p class="hdng1 p1-sec2"><span class="span1">
					Benefits of Hello Healthy Glucose Coffee with <?php echo $configs->step1_name; ?> Technology
				</p>
				<div class="hdngbrdrdiv hdngbrdrdiv-sec2"><img src="assets/images/shp-hdngbrdr.png" class="shp-hdngbrdr shp2-hdngbrdr"></div>
				<p class="p2-sec2">
					When you start enjoying <strong>Hello Healthy Glucose Coffee</strong> daily, you'll get more than just great taste 
					— you'll experience the power of <b><?php echo $configs->step1_name; ?> </b> Technology, a blend of clinically studied ingredients that helps support 
					blood sugar, metabolism, and energy — naturally and deliciously.			
				</p>
				<div class="points-bnfts">
					<div class="points-in-bnfts">
						<div class="bnfts-lftin">
							<p class="p3-sec2"><img src="assets/images/ic1-sec2.png" class="ic1-sec2">Helps Manage<span>Blood Sugar Levels</span></p>
							<p class="p4-sec2">
								Infused with clinically studied ingredients like <b>Reducose® White Mulberry Leaf Extract</b> and 
								<b>ABALife™ Fig Extract</b> to support healthy glucose metabolism and reduce post-meal sugar spikes.
							
							</p>
						</div>
						<div class="bnfts-rgtin">
							<p class="p3-sec2"><img src="assets/images/ic4-sec2.png" class="ic2-sec2">Blocks <span>Starch & Carb Breakdown</span></p>
							<p class="p4-sec2">
								The <b>Trojan22® metabolic blend</b> helps block enzymes that convert starches into sugar, turning fast carbs into slower, more manageable energy sources.
							</p>
						</div>
					</div>
					<div class="points-in-bnfts mrgn1-sec2">
						<div class="bnfts-lftin">
							<p class="p3-sec2"><img src="assets/images/ic2-sec2.png" class="ic1-sec2">Supports <span>Insulin Sensitivity</span></p>
							<p class="p4-sec2">
								By reducing glucose overload, <b><?php echo $configs->step1_name; ?> </b> helps support a healthier 
								insulin response — a key factor in preventing insulin resistance.
							</p>
						</div>
						<div class="bnfts-rgtin">
							<p class="p3-sec2"><img src="assets/images/ic5-sec2.png" class="ic2-sec2">Promotes <span>Steady Energy & Focus</span></p>
							<p class="p4-sec2">
								With 75 mg of natural caffeine, Cordyceps, and coffee cherry extract, this coffee helps you feel alert and energized — without the sugar crash.
							</p>
						</div>
					</div>
					<div class="points-in-bnfts">
						<div class="bnfts-lftin">
							<p class="p3-sec2"><img src="assets/images/ic3-sec2.png" class="ic1-sec2">Encourages <span>Healthy Weight Management</span></p>
							<p class="p4-sec2"> 
								Helps curb sugar spikes, block excess carb absorption, and support balanced blood sugar to make stubborn fat easier to lose.
							</p>
						</div>
						<div class="bnfts-rgtin">
							<p class="p3-sec2"><img src="assets/images/ic6-sec2.png" class="ic2-sec2">Supports <span>Heart & Metabolic Health</span></p>
							<p class="p4-sec2"> Packed with antioxidants, fiber, and botanicals that promote total-body wellness, including blood sugar, cholesterol, and inflammation support.</p>
						</div>
					</div>
					<img src="assets/brand/prod2.png" class="prod-sec2" width="350">
				</div>
			</div>
		</div>
	</div>
	<div id="content-mobile"></div>
	<!--========cta========-->
	<div class="cta" id="content-assets">
		<div class="container">
			<div class="cta-in">
				<img src="assets/brand/prod-bnr-btm2.png" class="" width="180" style="margin-right: 20px;">
				<div class="cta-lft">
					<p class="p1-cta">
						<span>Boost Your Metabolism & Balance Your Blood Sugar</span> — One Cup at a Time
					</p>
					<p class="p2-cta">
						Start your day with Hello Healthy Glucose Coffee, powered by <b><?php echo $configs->step1_name; ?> </b> 
						Technology — for steady energy, improved focus, and better blood sugar balance.
					</p>
				</div>
				<a href="#formid"><img src="assets/images/btn-ordr.png" class="btn-ordr-cta pulse"></a>
			</div>
		</div>
	</div>

	<!--=======section3=========-->
	<div class="section3">
		<div class="container">
			<div class="sec2-in">
				<p class="hdng1 p1-sec3"><span class="span1">
					Clinically Studied Ingredients in <br /><span class="hdng1">Hello Healthy Glucose Coffee with <?php echo $configs->corporate_name; ?> Technology</span>
				</p>
				<div class="hdngbrdrdiv hdngbrdrdiv-sec2"><img src="assets/images/shp-hdngbrdr.png";  class="shp-hdngbrdr shp2-hdngbrdr"></div>
				<p class="p2-sec3">
					Each serving of <b>Hello Healthy Glucose Coffee</b> contains the  <b><?php echo $configs->corporate_name; ?> blend</b> — a carefully selected mix of botanical extracts, 
					adaptogens, and patented ingredients designed to help manage blood sugar, improve insulin response, and promote steady energy 
					levels naturally.
				</p>
				<div class="points-sec3">
					<img src="assets/images/points-img-sec3.png" class="points-img-sec3">
					<p class="p3-sec3 po1-sec3 assets">
						<span class="span1"><span>White</span> Mulberry Leaf</span>
						Helps reduce the risk of diabetes and lowers high blood sugar levels.
					</p>
					<p class="p3-sec3 po2-sec3 juniper"><span class="span1">
						<span>Juniper</span> Berry</span>
						Supports inflammation control and promotes healthy weight loss.
					</p>
					<p class="p3-sec3 po3-sec3 padd1-sec3 assets">
						<span class="span1"><span>Biotin +</span>Chromium</span>
						Helps lower blood pressure, improve natural energy, and support glucose metabolism.
					</p>
					<p class="p3-sec3 po4-sec3 padd2-sec3"><span class="span1">
						<span>Vitamin C + E</span>Extract</span>
						Antioxidants that lower cholesterol and help reduce excessive glucose production in the liver.
					</p>
					<p class="p3-sec3 po5-sec3">
						<span class="span1"><span>Bitter</span>Melon</span>
						May lower bad cholesterol and increase healthy cholesterol levels.
					</p>
				</div>
				<div class="clearall"></div>
				<div class="ingrdiv-sec3">
					<img src="assets/images/ingr-sec3.png" class="ingr-sec3">
					<p class="p4-sec3"><span>Cinnamon</span> Bark Powder</p>
					<img src="assets/images/brdr-ingr-sec3.png" class="brdr-ingr-sec3">
					<div class="clearall"></div>
					<p class="p5-sec3">Helps regulate insulin levels and improve insulin sensitivity.</p>
				</div>
				<p class="p6-sec3 natImg"><span class="span1"><span>100%</span> Made from</span><span class="span2">All Natural</span><span class="span3">Ingredients</span></p>
			</div>
		</div>
	</div>

	<!--========cta========-->
	<div class="cta">
		<div class="container">
			<div class="cta-in">
				<div class="cta-lft">
					<p class="p1-cta"><span>Ready</span> To Take Control of Your Blood Sugar?</p>
					<p class="p2-cta">Feel the difference <b><?php echo $configs->step1_name; ?> </b> makes!</p>
				</div>
				<a href="#formid"><img src="assets/images/btn-ordr.png" class="btn-ordr-cta pulse"></a>
			</div>
		</div>
	</div>

	<!--=======section4=========-->
	<div class="section4">
		<div class="container">
			<div class="sec4-in">
				<p class="hdng1 p1-sec4"><span class="span1">
					Real People. Real Results.<br> Hello Healthy Glucose Coffee</span>
					 — Powered by <?php echo $configs->step1_name; ?></p>
				<div class="hdngbrdrdiv hdngbrdrdiv-sec2"><img src="assets/images/shp-hdngbrdr.png" class="shp-hdngbrdr shp2-hdngbrdr"></div>
				<p class="p2-sec4">
					Here's what customers are saying after making Hello Healthy Glucose Coffee with <b><?php echo $configs->step1_name; ?> </b> 
					Technology part of their daily routine — and seeing real changes in energy, blood sugar, and overall well-being.
				</p>
				<div class="testi-div">
					<div class="testi-in-div">
						<p class="p3-sec4"><img src="assets/images/img1-testi.png" class="img-testi"><span>I finally feel in control after meals.</span></p>
						<img src="assets/images/shp-testi.png" class="shp-testi">
						<p class="p4-sec4">
							After just two weeks of drinking Hello Healthy Glucose Coffee before lunch, I stopped getting those awful 
							crashes and cravings. My energy feels so much more stable throughout the day — and I've even lost a few pounds 
							without changing much else!”
						</p>
						<p class="p5-sec4">
							<img src="assets/images/verified-badge.png" class="verified-badge" height="20" width="20">
							<span class="span1"><span class="span2">Nicole R.,</span> CA</span>
							<img src="assets/images/stars-testi.png" class="stars-testi">
						</p>
					</div>
					<div class="testi-in-div mrgn1-sec4">
						<p class="p3-sec4"><img src="assets/images/img2-testi.png" class="img-testi"><span>Tastes great — and actually works.</span></p>
						<img src="assets/images/shp-testi.png" class="shp-testi">
						<p class="p4-sec4">
							I was skeptical about a functional coffee, but wow — this stuff is amazing. I feel focused, energized, 
							and my blood sugar readings are the most consistent they've been in months. Way better than taking another pill!
						</p>
						<p class="p5-sec4">
							<img src="assets/images/verified-badge.png" class="verified-badge" height="20" width="20">
							<span class="span1"><span class="span2">Marcus L.,</span> GA</span>
							<img src="assets/images/stars-testi.png" class="stars-testi">
						</p>
					</div>
					<div class="testi-in-div">
						<p class="p3-sec4"><img src="assets/images/img3-testi.png" class="img-testi"><span>Love that it's natural and backed by research. </span></p>
						<img src="assets/images/shp-testi.png" class="shp-testi">
						<p class="p4-sec4">
							Knowing Hello Healthy Glucose Coffee uses real clinical ingredients 
							like Reducose® made me feel good about trying it. 
							It tastes great — and now it's part of my morning ritual!”
						</p>
						<p class="p5-sec4">
							<img src="assets/images/verified-badge.png" class="verified-badge" height="20" width="20">
							<span class="span1"><span class="span2">Janelle M.,</span> NY</span>
							<img src="assets/images/stars-testi.png" class="stars-testi">
						</p>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!--========cta========-->
	<div class="cta assets">
		<div class="container">
			<div class="cta-in">
				<div class="cta-lft">
					<p class="p1-cta"><span>A Smarter Way to Support Blood Sugar, Energy & Healthy Weight</span>— In Every Cup</p>
					<p class="p2-cta">
						Start your day with <b>Hello Healthy Glucose Coffee</b>, powered by <b><?php echo $configs->step1_name; ?></b> Technology — 
						clinically backed, naturally effective, and delicious.
					</p>
				</div>
				<a href="#formid"><img src="assets/images/btn-ordr.png" class="btn-ordr-cta pulse"></a>
			</div>
		</div>
	</div>

	<!--========section5========-->
	<div class="section5">
		<div class="container">
			<div class="sec5-in assets">
				<img src="assets/brand/logo.png" class="logo-sec5" style="height: 150px;">
				<img src="assets/images/p1img-bnr.png" class="p1img-sec5 assets">
				<p class="p2-sec5 assets">Safely &amp; Naturally</p>
				<p class="p3-sec5 assets" style="font-size: 14px;">Turn Fast Carbs into Slow Energy With GlucoTrojan™</p>
				<p class="p4-bnrhm assets">The Coffee That Helps Block Sugar Spikes </p>
				<ul class="points-sec5 assets">
					<li><span>Helps</span> maintain healthy blood sugar levels</li>
					<li><span>Blocks</span> starch & sugar absorption before meals</li>
					<li><span>Improves</span> energy & focus without the crash</li>
					<li><span>Supports</span> energy & focus without the crash/li>
					<li><span>Infused</span> with <b>Reducose®, ABALife™, & Trojan22®</b> Blend</li>
				</ul>
				<p class="limited-text"><i>Limited stocks only!</i></p>
				<a href="#formid"><img src="assets/images/btn-ordr.png" class="btn-sec5 pulse"></a>
				<img src="assets/brand/prod-bnr-btm-mug.png" class="prod-sec5" width="733">
				<img src="assets/images/seals-sec5.png" class="seals-sec5">
			</div>
		</div>
	</div>
</div>

<!-- footer section -->
<div class="footer">
	<div class="container">
		<p class="p1-ftr">This product has not been evaluated by the FDA. This product is not intended to diagnose, treat, cure or prevent any disease.<br> Results in description and testimonials may not be typical results and individual results may vary.<br> This product is intended to be used in conjunction with a healthy diet and regular exercise.<br> Consult your physician before starting any diet, exercise program, and taking any diet pill to avoid any health issues.</p>
		<ul class="list-ftr">
			<li>
				<a href="javascript:void(0);" onclick="openNewWindow('./disclosures/privacy.php','modal');">Privacy Policy </a>
			</li>
			<li>
				<a href="javascript:void(0);" onclick="openNewWindow('./disclosures/terms.php','modal');">Terms and Conditions </a>
			</li>
			<li>
				<a href="javascript:void(0);" onclick="openNewWindow('./disclosures/contact.php','modal');">Contact </a>
			</li>
		</ul>
		<br>
		
		<p class="p2-ftr">2025 © GlucoTrojan</p>
	</div>
</div>
<!-- end footer section -->

<!--popup processing wrapper-->
<section id="loading-indicator" class="popup-loading-wrapper" style="display: none">
	<div class="popup">
		<img src="<?php echo $configs->root_path . "/assets/images/icon-lock.png"; ?>" alt="" class="lock-image" />
		<p>Please wait a moment</p>
		<h3>Your Product Is Being Reserved</h3>
		<img src="<?php echo $configs->root_path . "/assets/images/icon-loading.png"; ?>" alt="" class="loading-image" />
	</div>
</section>
<!--end popup processing wrapper-->
<?php if (isset($_GET["mode"]) && $_GET["mode"] == "failure") : ?>
	<script>
		alert("<?php echo $_GET["err_msg"]; ?>");
	</script>
<?php endif; ?>
<script type="text/javascript" src="<?php echo $configs->root_path . "/assets/js/jquery.min.js"; ?>"></script>
<script src="<?php echo $configs->root_path . "/assets/js/jquery.mask.min.js"; ?>"></script>
<script type="text/javascript" src="<?php echo $configs->root_path . "/assets/js/jquery.autocomplete.min.js"; ?>"></script>
<script src="<?php echo $configs->root_path . "/assets/js/scripts.js"; ?>" type="text/javascript"></script>
<script src="<?php echo $configs->root_path . "/assets/js/flipclock.js"; ?>" type="text/javascript"></script>
<script type="text/javascript">
	var smtKey = '<?php echo $configs->smartystreets_key; ?>';
	var smtAuto = <?php echo $configs->smartystreets_autocomplete_enabled; ?>;
	var smtVerify = <?php echo $configs->smartystreets_verification_enabled; ?>;
	var smartUrl = "https://us-autocomplete-pro.api.smartystreets.com/lookup?key=" + smtKey + "&prefer_geolocation=city";
	var lastAddress1 = '';
	var lastAddress2 = '';

	$(document).ready(function() {
		$(".icon-close").on('click', function() {
			console.log('work')
			$(".alert-row").fadeTo('fast', 0);
		})

		$('.cta').on('click', function() {
			$('html, body').animate({
				scrollTop: "0px"
			}, "slow");
			return false;
		});

		$('#fields_phone').mask('(000) 000-0000');

		var clock = $('.clock').FlipClock(600, {
			countdown: true
		});
	});

	if (typeof smtKey !== "undefined" && smtKey != '') {
		function submitAddress2() {
			if (lastAddress1 == '') {
				lastAddress1 = $('input[name="fields_address1"]').val();
				lastAddress1.replace('"', '');
			}
			lastAddress2 = $('input[name="fields_address2"]').val();
			lastAddress2.replace('"', '');
			var combAddr = lastAddress1 + ', ' + lastAddress2;
			$('input[name="fields_address1"]').val(combAddr);
			$('#app_common_modal').remove();
			$('#theForm').trigger('submit');
			return false;
		}

		var utils2 = (function() {
			return {
				escapeRegExChars: function(value) {
					return value.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&");
				},
				createNode: function(containerClass) {
					var div = document.createElement('div');
					div.className = containerClass;
					div.style.position = 'absolute';
					div.style.display = 'none';
					return div;
				}
			};
		}());

		$(document).ready(function(ee) {
			if (typeof smtAuto !== "undefined" && smtAuto == 1) {
				$('#fields_address1').autocomplete({
					serviceUrl: smartUrl,
					paramName: "search",
					ajaxSettings: {},
					minChars: 2,
					deferRequestBy: 400,
					transformResult: function(response) {
						if (typeof response === "undefined") {
							return {
								"suggestions": []
							};
						} else if (typeof response == "string") {
							respJson = JSON.parse(response);
						} else {
							respJson = response;
						}
						if (!(respJson) || typeof respJson.suggestions === "undefined" || respJson.suggestions == null) {
							return {
								"suggestions": []
							};
						}

						return {
							suggestions: $.map(respJson.suggestions, function(dataItem) {
								return {
									value: dataItem.street_line + (dataItem.secondary != '' && dataItem.entries == 1 ? (', ' + dataItem.secondary) : ''),
									data: dataItem
								};
							})
						};
					},
					formatResult: function(suggestion, currentValue) {
						if (typeof suggestion.data === "undefined") {
							return "";
						} else {
							if (!currentValue) {
								return suggestion.data.text;
							}

							var pattern = '(' + utils2.escapeRegExChars(currentValue) + ')';

							var addrfull = suggestion.data.street_line + (
								suggestion.data.secondary != '' ? (
									suggestion.data.entries > 1 ? (', ' + suggestion.data.secondary + ' (' + suggestion.data.entries + ' entries)') : (', ' + suggestion.data.secondary)
								) : '') + ', ' + suggestion.data.city + ' ' + suggestion.data.state + ' ' + suggestion.data.zipcode;

							return addrfull
								.replace(new RegExp(pattern, 'gi'), '<strong>$1<\/strong>')
								.replace(/&/g, '&amp;')
								.replace(/</g, '&lt;')
								.replace(/>/g, '&gt;')
								.replace(/"/g, '&quot;')
								.replace(/&lt;(\/?strong)&gt;/g, '<$1>');
						}
					},
					onSelect: function(suggestion) {
						if ($('#fields_city').length == 1 && (suggestion.data.city)) {
							$('#fields_city').val(suggestion.data.city);
						}
						if ($('#fields_state').length == 1 && (suggestion.data.state)) {
							$('#fields_state').val(suggestion.data.state);
						}
						if ($('#fields_zip').length == 1 && (suggestion.data.zipcode)) {
							$('#fields_zip').val(suggestion.data.zipcode);
						}
					}
				});
			}
		});
	}
	$('form.form123').find('#fields_email').on('change keyup', function() {
		var emailReg2 = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
		if (!emailReg2.test($('#fields_email').val())) {
			$(this).addClass('has-error');
			$(this).removeClass('no-error');
		}
	});

	$('form.form123').find('#fields_zip').on('change keyup', function() {
		var zip = $('#fields_zip').val();
		if ((zip.length) < 5) {
			$(this).addClass('has-error');
			$(this).removeClass('no-error');
		}
	});

	$('form#theForm').find('input, select, textarea').on('change keyup', function() {
		$('form#theForm').find('input, select').each(function() {
			if ($(this).val() == '') {
				$(this).addClass('has-error');
				$(this).removeClass('no-error');
			} else {
				$(this).removeClass('has-error');
				$(this).addClass('no-error');
			}
		});
	});

	function validate_optin_form() {
		ShowExitPopup = false;
		internal = 1;
		isExit = false;
		var errors = new Array();
		var phonefilter = /^([0-9\-\+\(\)]{8,22})+$/;
		var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;

		$("input").removeClass("has-error");

		if ($('#fields_fname').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your first name');
			$('#fields_fname').addClass("has-error");
		}
		if ($('#fields_lname').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your last name');
			$('#fields_lname').addClass("has-error");
		}
		if ($('#fields_address1').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please select your address');
			$('#fields_address1').addClass("has-error");
		}
		if ($('#fields_city').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your city');
			$('#fields_city').addClass("has-error");
		}
		if ($('#fields_state').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your State');
			$('#fields_state').addClass("has-error");
		}
		if ($('#fields_zip').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your Zip Code');
			$('#fields_zip').addClass("has-error");
		}
		if ($('#fields_phone').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your phone number');
			$('#fields_phone').addClass("has-error");
		} else if ($('#fields_phone').val().replace(/^\s+|\s+$/g, "").length < 14) {
			errors.push('Phone number must be at least 10 digits');
			$('#fields_phone').addClass("has-error");
		}
		if ($('#fields_email').val().replace(/^\s+|\s+$/g, "") == '') {
			errors.push('Please enter your email address');
			$('#fields_email').addClass("has-error");
		} else if (!emailReg.test($('#fields_email').val())) {
			errors.push('Please enter valid email address');
			$('#fields_email').addClass("has-error");
		}

		if (typeof smtKey !== "undefined" && smtKey != '' && typeof smtVerify !== "undefined" && smtVerify == 1) {
			if (errors.length == 0) {
				var addr = $('input[name="fields_address1"]').val() + ', ' + $('input[name="fields_city"]').val() + ' ' + $('select[name="fields_state"]').val() + ' ' + $('input[name="fields_zip"]').val();
				var errmsg = "";
				var vcode = "";
				var apiUrl = "https://us-street.api.smartystreets.com/street-address" +
					"?street=" + encodeURI(addr) +
					"&key=" + smtKey;
				$.ajax({
						url: apiUrl,
						method: "get",
						async: false,
						beforeSend: function(xhr) {}
					})
					.done(function(resData) {
						var errmsg = "";
						if (!(resData) || !(resData[0]) || !(resData[0].analysis) || !(resData[0].analysis.dpv_match_code)) {
							vcode = "";
						} else {
							vcode = resData[0].analysis.dpv_match_code;
						}

						if (vcode != '' && vcode != 'N' && vcode != 'D') {
							if (typeof resData[0].delivery_line_1 !== "undefined" && resData[0].delivery_line_1 != "") {
								$('input[name="fields_address1"]').val(resData[0].delivery_line_1);
								lastAddress1 = $('input[name="fields_address1"]').val();
							}

							if (typeof resData[0].components !== "undefined") {
								if (typeof resData[0].components.city_name !== "undefined" && resData[0].components.city_name != "") {
									$('input[name="fields_city"]').val(resData[0].components.city_name);
								}
								if (typeof resData[0].components.zipcode !== "undefined" && resData[0].components.zipcode != "") {
									$('input[name="fields_zip"]').val(resData[0].components.zipcode);
								}
								if (typeof resData[0].components.state_abbreviation !== "undefined" && resData[0].components.state_abbreviation != "") {
									$('select[name="fields_state"]').val(resData[0].components.state_abbreviation);
								}
							}
						}
					})
					.fail(function() {})
					.always(function() {});

				if (vcode == '') {
					errors.push('Address could not be found');
				} else if (vcode == 'N') {
					errors.push('Address does not seem to be deliverable');
				} else if (vcode == 'D') {
					var html = '';
					html += '<div id="app_common_modal">';
					html += '<div class="app_modal_body" style="text-align:center;min-height:150px;"><a href="javascript:void(0);" id="app_common_modal_close">X</a>';
					html += '<div>' +
						'<form method="get" action="" onSubmit="return submitAddress2();">' +
						'<h4>' + "Please enter your Apartment/Suite/Unit # to proceed" + '</h4>' +
						'<input type="text" name="fields_address2" id="fields_address2" placeholder="" autocomplete="off" required style="width:80%;line-height:22px;margin:10px;padding:5px" maxlength="50" value="' + (lastAddress2 != '' ? lastAddress2 : '') + '" data-error-message="Please enter your address!" />' +
						'<button type="submit" style="width:40%;height:30px;line-height:22px;cursor:pointer;">OK</button>' +
						'</form>'; +
					'</div>';
					html += '</div>';
					html += '</div>';

					if (!$('#app_common_modal').length) {
						$('body').append(html);
					}
					$('#app_common_modal').fadeIn(500);
					return false;
				}
			}
		}

		if (errors.length == 0) {
			$('.popup-loading-wrapper').show();
			$('#fields_phone').unmask();
			document.getElementById('theForm').submit();
			return false;
		} else {
			var li = '';
			$.each(errors, function(key, value) {
				li += '<li>' + value + '</li>';
			});

			var html = '';
			html += '<div id="error_handler_overlay">';
			html += '<div class="error_handler_body"><a href="javascript:void(0);" id="error_handler_overlay_close">X</a><ul>' + li + '</ul></div>';
			html += '</div>';

			$('body').append(html);
			$('#error_handler_overlay').fadeIn(500);
			return false;
		}
	}

	$(function() {
		$(window).keydown(function(e) {
			if (e.which === 27 && $('#error_handler_overlay').length) {
				$('#error_handler_overlay').remove();
			}
		});

		$(document).off('click', '#error_handler_overlay');
		$(document).on('click', '#error_handler_overlay', function() {
			$(this).remove();
		});

		$(document).off('click', '#error_handler_overlay_close');
		$(document).on('click', '#error_handler_overlay_close', function() {
			$('#error_handler_overlay').remove();
		});

		$(document).on('click', '#app_common_modal_close', function() {
			$('#app_common_modal').remove();
		});
	});

    function openNewWindow(page_url, type, window_name, width, height, top, left, features) {
        if (!type) {
            type = 'popup';
        }
        if (!width) {
            width = 480;
        }
        if (!height) {
            height = 480;
        }
        if (!top) {
            top = 50;
        }
        if (!left) {
            left = 50;
        }
        if (!features) {
            features = 'resizable,scrollbars';
        }

        if (type == 'popup') {
            var settings = 'height=' + height + ',';
            settings += 'width=' + width + ',';
            settings += 'top=' + top + ',';
            settings += 'left=' + left + ',';
            settings += features;
            win = window.open(page_url, window_name, settings);
            win.window.focus();
        } else if (type == 'modal') {
            var html = '';
            html += '<div id="app_common_modal">';
            html += '<div class="app_modal_body"><a href="javascript:void(0);" id="app_common_modal_close">X</a><iframe src="' + page_url + '" frameborder="0"></iframe></div>';
            html += '</div>';

            if (!$('#app_common_modal').length) {
                $('body').append(html);
            }
            $('#app_common_modal').fadeIn();
        }
    }
</script>
<?php if (empty($_GET['c3'])): ?>
        <script type="text/javascript" src="https://www.ozmnvb8trk.com/scripts/sdk/everflow.js"></script>
        <script type="text/javascript">
            EF.click({
                    offer_id: EF.urlParameter('oid'),
                    affiliate_id: EF.urlParameter('AFFID'),
                    sub1: EF.urlParameter('c2'),
                    sub2: EF.urlParameter('sub2'),
                    sub3: EF.urlParameter('c6'),
                    sub4: EF.urlParameter('google'),
                    sub5: EF.urlParameter('meta'),
                    uid: EF.urlParameter('uid'),
                    source_id: EF.urlParameter('c1'),
                })
                .then((transactionId) => {
                    $.ajax({
                        url: './set-ef-tid.php',
                        method: 'POST',
                        data: {
                            transaction_id: transactionId
                        },
                        success: function(response) {
                            console.log('Transaction ID saved successfully:', response);
                        },
                        error: function(xhr, status, error) {
                            console.error('Error saving Transaction ID:', error);
                        }
                    });
                });
        </script>
    <?php endif ?>
</body>
</html>